/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.controllers;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.function.Function;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.file.FileUtil;

public class ControllerConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final ConfigManager configManager;

    protected ControllerConfig(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public IApplicationConfig getAppConfig() {
        return this.configManager.getAppConfig();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getConfigFile() {
        return this.getAppConfig().getString((IOption)Option.CONFIG_FILE);
    }

    public void setConfigFile(String configFile) {
        this.configManager.set(Option.CONFIG_FILE, configFile);
    }

    public URL getConfigFileUrl() {
        return (URL)this.getAppConfig().get((IOption)Option.CONFIG_FILE_URL);
    }

    public void setConfigFileUrl(URL configFileUrl) {
        this.configManager.set(Option.CONFIG_FILE_URL, configFileUrl);
    }

    public String getLogDir() {
        String relPath = this.configManager.getAppConfig().getString((IOption)Option.LOG_DIR);
        String fullPath = new File(relPath).getAbsolutePath();
        return fullPath;
    }

    public boolean isSslEnabled() {
        return this.getAppConfig().getBoolean((IOption)Option.SSL_ENABLED);
    }

    public static enum Option implements IOption
    {
        CONFIG_FILE(OptionTypes.STRING, (String)null, "Specify path to master configuration file"),
        CONFIG_FILE_URL(OptionTypes.URL, (URL)null, "Specify URL to master configuration file"),
        DEFAULT_DIR(OptionTypes.STRING, FileUtil.joinPath((String[])new String[]{System.getProperty("java.io.tmpdir"), "hyracks"}), "Directory where files are written to by default"),
        LOG_DIR(OptionTypes.STRING, appConfig -> FileUtil.joinPath((String[])new String[]{appConfig.getString((IOption)DEFAULT_DIR), "logs"}), "The directory where logs for this node are written"),
        SSL_ENABLED(OptionTypes.BOOLEAN, false, "A flag indicating if cluster communications should use secured connections");

        private final IOptionType type;
        private final String description;
        private Object defaultValue;

        private <T> Option(IOptionType<T> type, T defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        private <T> Option(IOptionType<T> type, Function<IApplicationConfig, T> defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.COMMON;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

