/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.netty.http;

import com.typesafe.netty.CancelledSubscriber;
import com.typesafe.netty.http.DelegateStreamedHttpResponse;
import com.typesafe.netty.http.EmptyHttpResponse;
import com.typesafe.netty.http.HttpStreamsHandler;
import com.typesafe.netty.http.StreamedHttpMessage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class HttpStreamsClientHandler
extends HttpStreamsHandler<HttpResponse, HttpRequest> {
    private int inFlight = 0;
    private int withServer = 0;
    private ChannelPromise closeOnZeroInFlight = null;
    private Subscriber<HttpContent> awaiting100Continue;
    private StreamedHttpMessage awaiting100ContinueMessage;
    private boolean ignoreResponseBody = false;

    public HttpStreamsClientHandler() {
        super(HttpResponse.class, HttpRequest.class);
    }

    @Override
    protected boolean hasBody(HttpResponse response) {
        if (response.status().code() >= 100 && response.status().code() < 200) {
            return false;
        }
        if (response.status().equals((Object)HttpResponseStatus.NO_CONTENT) || response.status().equals((Object)HttpResponseStatus.NOT_MODIFIED)) {
            return false;
        }
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)response)) {
            return true;
        }
        if (HttpUtil.isContentLengthSet((HttpMessage)response)) {
            return HttpUtil.getContentLength((HttpMessage)response) > 0L;
        }
        return true;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        if (this.inFlight == 0) {
            ctx.close(future);
        } else {
            this.closeOnZeroInFlight = future;
        }
    }

    @Override
    protected void consumedInMessage(ChannelHandlerContext ctx) {
        --this.inFlight;
        --this.withServer;
        if (this.inFlight == 0 && this.closeOnZeroInFlight != null) {
            ctx.close(this.closeOnZeroInFlight);
        }
    }

    @Override
    protected void receivedOutMessage(ChannelHandlerContext ctx) {
        ++this.inFlight;
    }

    @Override
    protected void sentOutMessage(ChannelHandlerContext ctx) {
        ++this.withServer;
    }

    @Override
    protected HttpResponse createEmptyMessage(HttpResponse response) {
        return new EmptyHttpResponse(response);
    }

    @Override
    protected HttpResponse createStreamedMessage(HttpResponse response, Publisher<HttpContent> stream) {
        return new DelegateStreamedHttpResponse(response, stream);
    }

    @Override
    protected void subscribeSubscriberToStream(StreamedHttpMessage msg, Subscriber<HttpContent> subscriber) {
        if (HttpUtil.is100ContinueExpected((HttpMessage)msg)) {
            this.awaiting100Continue = subscriber;
            this.awaiting100ContinueMessage = msg;
        } else {
            super.subscribeSubscriberToStream(msg, subscriber);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse && this.awaiting100Continue != null && this.withServer == 0) {
            HttpResponse response = (HttpResponse)msg;
            if (response.status().equals((Object)HttpResponseStatus.CONTINUE)) {
                super.subscribeSubscriberToStream(this.awaiting100ContinueMessage, this.awaiting100Continue);
                this.awaiting100Continue = null;
                this.awaiting100ContinueMessage = null;
                if (msg instanceof FullHttpResponse) {
                    ReferenceCountUtil.release((Object)msg);
                } else {
                    this.ignoreResponseBody = true;
                }
            } else {
                this.awaiting100ContinueMessage.subscribe((Subscriber)new CancelledSubscriber());
                this.awaiting100ContinueMessage = null;
                this.awaiting100Continue.onSubscribe(new Subscription(){

                    public void request(long n) {
                    }

                    public void cancel() {
                    }
                });
                this.awaiting100Continue.onComplete();
                this.awaiting100Continue = null;
                super.channelRead(ctx, msg);
            }
        } else if (this.ignoreResponseBody && msg instanceof HttpContent) {
            ReferenceCountUtil.release((Object)msg);
            if (msg instanceof LastHttpContent) {
                this.ignoreResponseBody = false;
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }
}

