/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.plugins.RxJavaHooks;
import rx.subscriptions.SerialSubscription;

public final class CompletableOnSubscribeConcat
implements Completable.CompletableOnSubscribe {
    final Observable<Completable> sources;
    final int prefetch;

    public CompletableOnSubscribeConcat(Observable<? extends Completable> sources, int prefetch) {
        this.sources = sources;
        this.prefetch = prefetch;
    }

    @Override
    public void call(Completable.CompletableSubscriber s) {
        CompletableConcatSubscriber parent = new CompletableConcatSubscriber(s, this.prefetch);
        s.onSubscribe(parent);
        this.sources.subscribe(parent);
    }

    static final class CompletableConcatSubscriber
    extends Subscriber<Completable> {
        final Completable.CompletableSubscriber actual;
        final int prefetch;
        final SerialSubscription sr;
        final SpscArrayQueue<Completable> queue;
        volatile boolean done;
        final AtomicBoolean once;
        final ConcatInnerSubscriber inner;
        final AtomicInteger wip;

        public CompletableConcatSubscriber(Completable.CompletableSubscriber actual, int prefetch) {
            this.actual = actual;
            this.prefetch = prefetch;
            this.queue = new SpscArrayQueue(prefetch);
            this.sr = new SerialSubscription();
            this.inner = new ConcatInnerSubscriber();
            this.wip = new AtomicInteger();
            this.once = new AtomicBoolean();
            this.add(this.sr);
            this.request(prefetch);
        }

        @Override
        public void onNext(Completable t) {
            if (!this.queue.offer(t)) {
                this.onError(new MissingBackpressureException());
                return;
            }
            if (this.wip.getAndIncrement() == 0) {
                this.next();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(t);
                return;
            }
            RxJavaHooks.onError(t);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.next();
            }
        }

        void innerError(Throwable e) {
            this.unsubscribe();
            this.onError(e);
        }

        void innerComplete() {
            if (this.wip.decrementAndGet() != 0) {
                this.next();
            }
            if (!this.done) {
                this.request(1L);
            }
        }

        void next() {
            boolean d = this.done;
            Completable c = this.queue.poll();
            if (c == null) {
                if (d) {
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onCompleted();
                    }
                    return;
                }
                RxJavaHooks.onError(new IllegalStateException("Queue is empty?!"));
                return;
            }
            c.unsafeSubscribe(this.inner);
        }

        final class ConcatInnerSubscriber
        implements Completable.CompletableSubscriber {
            ConcatInnerSubscriber() {
            }

            @Override
            public void onSubscribe(Subscription d) {
                CompletableConcatSubscriber.this.sr.set(d);
            }

            @Override
            public void onError(Throwable e) {
                CompletableConcatSubscriber.this.innerError(e);
            }

            @Override
            public void onCompleted() {
                CompletableConcatSubscriber.this.innerComplete();
            }
        }
    }
}

