/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.compression.ICompressorDecompressor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.xerial.snappy.Snappy;

public class SnappyCompressorDecompressor
implements ICompressorDecompressor {
    protected static final SnappyCompressorDecompressor INSTANCE = new SnappyCompressorDecompressor();

    private SnappyCompressorDecompressor() {
    }

    public int computeCompressedBufferSize(int uncompressedBufferSize) {
        return Snappy.maxCompressedLength((int)uncompressedBufferSize);
    }

    public ByteBuffer compress(ByteBuffer uBuffer, ByteBuffer cBuffer) throws HyracksDataException {
        try {
            int cLength = Snappy.compress((byte[])uBuffer.array(), (int)uBuffer.position(), (int)uBuffer.remaining(), (byte[])cBuffer.array(), (int)cBuffer.position());
            cBuffer.limit(cBuffer.position() + cLength);
            return cBuffer;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public ByteBuffer uncompress(ByteBuffer cBuffer, ByteBuffer uBuffer) throws HyracksDataException {
        try {
            int uLength = Snappy.uncompress((byte[])cBuffer.array(), (int)cBuffer.position(), (int)cBuffer.remaining(), (byte[])uBuffer.array(), (int)uBuffer.position());
            uBuffer.limit(uBuffer.position() + uLength);
            return uBuffer;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

