/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeLaxEvaluator;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;

@MissingNullInOutFunction
public class CastTypeLaxDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new CastTypeLaxDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return new FunctionTypeInferers.CastTypeInferer();
        }
    };
    private static final long serialVersionUID = 1L;
    private IAType reqType;
    private IAType inputType;

    private CastTypeLaxDescriptor() {
    }

    public void setImmutableStates(Object ... states) {
        this.reqType = (IAType)states[0];
        this.inputType = (IAType)states[1];
        if (this.reqType == null || this.inputType == null || this.reqType.equals(this.inputType)) {
            throw new IllegalStateException("Invalid types for casting, required type " + this.reqType + ", input type " + this.inputType);
        }
        this.reqType = TypeComputeUtils.getActualType((IAType)this.reqType);
        this.inputType = TypeComputeUtils.getActualType((IAType)this.inputType);
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CAST_TYPE_LAX;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        final IScalarEvaluatorFactory recordEvalFactory = args[0];
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                IScalarEvaluator argEval = recordEvalFactory.createScalarEvaluator(ctx);
                return new CastTypeLaxEvaluator(CastTypeLaxDescriptor.this.reqType, CastTypeLaxDescriptor.this.inputType, argEval, CastTypeLaxDescriptor.this.sourceLoc);
            }
        };
    }
}

