/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class StringSplitDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new StringSplitDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IScalarEvaluator stringEval;
                    private final IScalarEvaluator patternEval;
                    private final IPointable argString;
                    private final IPointable argPattern;
                    private final UTF8StringPointable argStrPtr;
                    private final UTF8StringPointable argPatternPtr;
                    private final ArrayBackedValueStorage itemStorge;
                    private final DataOutput itemOut;
                    private final byte[] tempLengthArray;
                    private final AOrderedListType intListType;
                    private final OrderedListBuilder listBuilder;
                    private final ArrayBackedValueStorage resultStorage;
                    private final DataOutput out;
                    {
                        this.stringEval = args[0].createScalarEvaluator(ctx);
                        this.patternEval = args[1].createScalarEvaluator(ctx);
                        this.argString = new VoidPointable();
                        this.argPattern = new VoidPointable();
                        this.argStrPtr = new UTF8StringPointable();
                        this.argPatternPtr = new UTF8StringPointable();
                        this.itemStorge = new ArrayBackedValueStorage();
                        this.itemOut = this.itemStorge.getDataOutput();
                        this.tempLengthArray = new byte[5];
                        this.intListType = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
                        this.listBuilder = new OrderedListBuilder();
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.out = this.resultStorage.getDataOutput();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            int nextMatchStart;
                            this.resultStorage.reset();
                            this.stringEval.evaluate(tuple, this.argString);
                            this.patternEval.evaluate(tuple, this.argPattern);
                            if (PointableHelper.checkAndSetMissingOrNull(result, this.argString, this.argPattern)) {
                                return;
                            }
                            byte[] srcString = this.argString.getByteArray();
                            int srcOffset = this.argString.getStartOffset();
                            int srcLen = this.argString.getLength();
                            if (srcString[srcOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                PointableHelper.setNull(result);
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)StringSplitDescriptor.this.sourceLoc, (FunctionIdentifier)StringSplitDescriptor.this.getIdentifier(), (byte)srcString[srcOffset], (int)0, (ATypeTag)ATypeTag.STRING);
                                return;
                            }
                            byte[] patternString = this.argPattern.getByteArray();
                            int patternOffset = this.argPattern.getStartOffset();
                            int patternLen = this.argPattern.getLength();
                            if (patternString[patternOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                PointableHelper.setNull(result);
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)StringSplitDescriptor.this.sourceLoc, (FunctionIdentifier)StringSplitDescriptor.this.getIdentifier(), (byte)patternString[patternOffset], (int)1, (ATypeTag)ATypeTag.STRING);
                                return;
                            }
                            this.argStrPtr.set(srcString, srcOffset + 1, srcLen - 1);
                            this.argPatternPtr.set(patternString, patternOffset + 1, patternLen - 1);
                            int inputStringLen = UTF8StringUtil.getUTFLength((byte[])srcString, (int)(srcOffset + 1));
                            int inputStringStart = srcOffset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)inputStringLen);
                            int inputPatternLen = UTF8StringUtil.getUTFLength((byte[])patternString, (int)(patternOffset + 1));
                            boolean emptyStringPattern = inputPatternLen == 0;
                            this.listBuilder.reset((AbstractCollectionType)this.intListType);
                            int itemStrStart = 0;
                            while (itemStrStart < inputStringLen && (nextMatchStart = UTF8StringPointable.find((UTF8StringPointable)this.argStrPtr, (UTF8StringPointable)this.argPatternPtr, (boolean)false, (int)itemStrStart)) >= 0) {
                                this.addItemString(srcString, inputStringStart, itemStrStart, emptyStringPattern ? nextMatchStart + 1 : nextMatchStart);
                                itemStrStart = nextMatchStart + (emptyStringPattern ? 1 : inputPatternLen);
                            }
                            if (!emptyStringPattern) {
                                this.addItemString(srcString, inputStringStart, itemStrStart, inputStringLen);
                            }
                            this.listBuilder.write(this.out, true);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e1) {
                            throw HyracksDataException.create((Throwable)e1);
                        }
                    }

                    private void addItemString(byte[] srcString, int inputStringStart, int itemStartOffset, int nextMatchStart) throws IOException {
                        int itemLen = nextMatchStart - itemStartOffset;
                        int cbytes = UTF8StringUtil.encodeUTF8Length((int)itemLen, (byte[])this.tempLengthArray, (int)0);
                        this.itemStorge.reset();
                        this.itemOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        this.itemOut.write(this.tempLengthArray, 0, cbytes);
                        if (itemLen > 0) {
                            this.itemOut.write(srcString, inputStringStart + itemStartOffset, itemLen);
                        }
                        this.listBuilder.addItem((IValueReference)this.itemStorge);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_SPLIT;
    }
}

