/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.runtime.evaluators.comparisons.DeepEqualAssessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class RecordMergeEvaluator
extends AbstractScalarEval {
    private final boolean isIgnoreDuplicates;
    private final ARecordType outRecType;
    private final IVisitablePointable vp0;
    private final IVisitablePointable vp1;
    private final IPointable argPtr0 = new VoidPointable();
    private final IPointable argPtr1 = new VoidPointable();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final List<RecordBuilder> rbStack = new ArrayList<RecordBuilder>();
    private final ArrayBackedValueStorage tabvs = new ArrayBackedValueStorage();
    private final IBinaryComparator stringBinaryComparator = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final RuntimeRecordTypeInfo runtimeRecordTypeInfo = new RuntimeRecordTypeInfo();
    private final DeepEqualAssessor deepEqualAssessor = new DeepEqualAssessor();
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();

    RecordMergeEvaluator(IEvaluatorContext ctx, IScalarEvaluatorFactory[] args, IAType[] argTypes, SourceLocation sourceLocation, FunctionIdentifier identifier, boolean isIgnoreDuplicates) throws HyracksDataException {
        super(sourceLocation, identifier);
        this.isIgnoreDuplicates = isIgnoreDuplicates;
        this.eval0 = args[0].createScalarEvaluator(ctx);
        this.eval1 = args[1].createScalarEvaluator(ctx);
        this.outRecType = (ARecordType)argTypes[0];
        ARecordType inRecType0 = (ARecordType)argTypes[1];
        ARecordType inRecType1 = (ARecordType)argTypes[2];
        PointableAllocator pa = new PointableAllocator();
        this.vp0 = pa.allocateRecordValue((IAType)inRecType0);
        this.vp1 = pa.allocateRecordValue((IAType)inRecType1);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.argPtr0);
        this.eval1.evaluate(tuple, this.argPtr1);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1)) {
            return;
        }
        this.vp0.set((IValueReference)this.argPtr0);
        this.vp1.set((IValueReference)this.argPtr1);
        ARecordVisitablePointable rp0 = (ARecordVisitablePointable)this.vp0;
        ARecordVisitablePointable rp1 = (ARecordVisitablePointable)this.vp1;
        try {
            this.mergeFields(this.outRecType, rp0, rp1, 0);
            this.rbStack.get(0).write(this.out, true);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    private void mergeFields(ARecordType combinedType, ARecordVisitablePointable leftRecord, ARecordVisitablePointable rightRecord, int nestedLevel) throws IOException {
        if (this.rbStack.size() < nestedLevel + 1) {
            this.rbStack.add(new RecordBuilder());
        }
        this.rbStack.get(nestedLevel).reset(combinedType);
        this.rbStack.get(nestedLevel).init();
        for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
            IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
            IVisitablePointable leftValue = (IVisitablePointable)leftRecord.getFieldValues().get(i);
            IVisitablePointable leftType = (IVisitablePointable)leftRecord.getFieldTypeTags().get(i);
            boolean foundMatch = false;
            for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
                IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
                IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
                IVisitablePointable rightType = (IVisitablePointable)rightRecord.getFieldTypeTags().get(j);
                if (!PointableHelper.isEqual((IValueReference)leftName, (IValueReference)rightName, this.stringBinaryComparator) || this.deepEqualAssessor.isEqual(leftValue, rightValue)) continue;
                if (PointableHelper.sameType(ATypeTag.OBJECT, rightType) && PointableHelper.sameType(ATypeTag.OBJECT, leftType)) {
                    this.addFieldToSubRecord(combinedType, leftName, leftValue, rightValue, nestedLevel);
                    foundMatch = true;
                    continue;
                }
                if (this.isIgnoreDuplicates) continue;
                throw new RuntimeDataException(ErrorCode.DUPLICATE_FIELD_NAME, new Serializable[]{this.funID});
            }
            if (foundMatch) continue;
            this.addFieldToSubRecord(combinedType, leftName, leftValue, null, nestedLevel);
        }
        for (int j = 0; j < rightRecord.getFieldNames().size(); ++j) {
            IVisitablePointable rightName = (IVisitablePointable)rightRecord.getFieldNames().get(j);
            IVisitablePointable rightValue = (IVisitablePointable)rightRecord.getFieldValues().get(j);
            boolean foundMatch = false;
            for (int i = 0; i < leftRecord.getFieldNames().size(); ++i) {
                IVisitablePointable leftName = (IVisitablePointable)leftRecord.getFieldNames().get(i);
                if (!rightName.equals(leftName)) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            this.addFieldToSubRecord(combinedType, rightName, rightValue, null, nestedLevel);
        }
    }

    private void addFieldToSubRecord(ARecordType combinedType, IVisitablePointable fieldNamePointable, IVisitablePointable leftValue, IVisitablePointable rightValue, int nestedLevel) throws IOException {
        this.runtimeRecordTypeInfo.reset(combinedType);
        int pos = this.runtimeRecordTypeInfo.getFieldIndex(fieldNamePointable.getByteArray(), fieldNamePointable.getStartOffset() + 1, fieldNamePointable.getLength() - 1);
        if (combinedType != null && pos >= 0) {
            if (rightValue == null) {
                this.rbStack.get(nestedLevel).addField(pos, (IValueReference)leftValue);
            } else {
                this.mergeFields((ARecordType)combinedType.getFieldTypes()[pos], (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, nestedLevel + 1);
                this.tabvs.reset();
                this.rbStack.get(nestedLevel + 1).write(this.tabvs.getDataOutput(), true);
                this.rbStack.get(nestedLevel).addField(pos, (IValueReference)this.tabvs);
            }
        } else if (rightValue == null) {
            this.rbStack.get(nestedLevel).addField((IValueReference)fieldNamePointable, (IValueReference)leftValue);
        } else {
            this.mergeFields(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, (ARecordVisitablePointable)leftValue, (ARecordVisitablePointable)rightValue, nestedLevel + 1);
            this.tabvs.reset();
            this.rbStack.get(nestedLevel + 1).write(this.tabvs.getDataOutput(), true);
            this.rbStack.get(nestedLevel).addField((IValueReference)fieldNamePointable, (IValueReference)this.tabvs);
        }
    }
}

