/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FileIndexTupleTranslator {
    private final ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(2);
    private RecordBuilder recordBuilder = new RecordBuilder();
    private ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
    private AMutableInt32 aInt32 = new AMutableInt32(0);
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableString aString = new AMutableString(null);
    private AMutableDateTime aDateTime = new AMutableDateTime(0L);
    private ISerializerDeserializer<IAObject> stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    private ISerializerDeserializer<IAObject> dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    private ISerializerDeserializer<IAObject> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ArrayTupleReference tuple = new ArrayTupleReference();

    public ITupleReference getTupleFromFile(ExternalFile file) throws HyracksDataException {
        this.tupleBuilder.reset();
        this.aInt32.setValue(file.getFileNumber());
        FilesIndexDescription.FILE_NUMBER_SERDE.serialize((Object)this.aInt32, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(FilesIndexDescription.EXTERNAL_FILE_RECORD_TYPE);
        this.fieldValue.reset();
        this.aString.setValue(file.getFileName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt64.setValue(file.getSize());
        this.longSerde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aDateTime.setValue(file.getLastModefiedTime().getTime());
        this.dateTimeSerde.serialize((Object)this.aDateTime, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

