/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.LineRecordReader;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.util.ParseUtil;

public class QuotedLineRecordReader
extends LineRecordReader {
    private char quote;
    private char escape;
    private boolean prevCharEscape;
    private int readLength;
    private boolean inQuote;
    private IWarningCollector warnings;
    private static final List<String> recordReaderFormats = Collections.unmodifiableList(Arrays.asList("delimited-text", "csv"));
    private static final String REQUIRED_CONFIGS = "quote";

    @Override
    public void configure(IHyracksTaskContext ctx, AsterixInputStream inputStream, Map<String, String> config) throws HyracksDataException {
        super.configure(ctx, inputStream, config);
        this.warnings = ctx.getWarningCollector();
        String quoteString = config.get(REQUIRED_CONFIGS);
        ExternalDataUtils.validateChar(quoteString, REQUIRED_CONFIGS);
        this.quote = quoteString.charAt(0);
        this.escape = ExternalDataUtils.validateGetEscape(config);
    }

    @Override
    public void notifyNewSource() {
        if (!this.record.isEmptyRecord() && this.warnings.shouldWarn()) {
            ParseUtil.warn((IWarningCollector)this.warnings, (String)this.getPreviousStreamName(), (long)this.lineNumber, (int)0, (String)"malformed input record ended abruptly");
        }
        this.resetForNewSource();
    }

    @Override
    public void resetForNewSource() {
        super.resetForNewSource();
        this.prevCharEscape = false;
        this.readLength = 0;
        this.inQuote = false;
    }

    @Override
    public List<String> getRecordReaderFormats() {
        return recordReaderFormats;
    }

    @Override
    public String getRequiredConfigs() {
        return REQUIRED_CONFIGS;
    }

    @Override
    public boolean hasNext() throws IOException {
        while (true) {
            if (this.done) {
                return false;
            }
            this.beginLineNumber = this.lineNumber;
            this.newlineLength = 0;
            this.prevCharCR = false;
            this.prevCharEscape = false;
            this.record.reset();
            this.readLength = 0;
            this.inQuote = false;
            do {
                int startPosn = this.bufferPosn;
                if (this.bufferPosn >= this.bufferLength) {
                    this.bufferPosn = 0;
                    startPosn = 0;
                    this.bufferLength = this.reader.read(this.inputBuffer);
                    if (this.bufferLength <= 0) {
                        if (this.readLength <= 0 || this.inQuote) {
                            if (this.inQuote && this.warnings.shouldWarn()) {
                                ParseUtil.warn((IWarningCollector)this.warnings, (String)this.getDataSourceName().get(), (long)this.lineNumber, (int)0, (String)"malformed input record ended abruptly");
                            }
                            this.close();
                            return false;
                        }
                        this.record.endRecord();
                        break;
                    }
                }
                boolean maybeInQuote = false;
                while (this.bufferPosn < this.bufferLength) {
                    char ch = this.inputBuffer[this.bufferPosn];
                    if (ch == '\n' || this.prevCharCR) {
                        ++this.lineNumber;
                    }
                    if (ch == this.quote && this.escape == this.quote) {
                        this.inQuote |= maybeInQuote;
                        this.prevCharEscape |= maybeInQuote;
                    }
                    maybeInQuote = false;
                    if (!this.inQuote) {
                        if (ch == '\n') {
                            this.newlineLength = this.prevCharCR ? 2 : 1;
                            ++this.bufferPosn;
                            break;
                        }
                        if (this.prevCharCR) {
                            this.newlineLength = 1;
                            break;
                        }
                        this.inQuote = ch == this.quote && !this.prevCharEscape;
                        this.prevCharEscape = ch == this.escape && !this.prevCharEscape && this.escape != this.quote;
                    } else {
                        if (ch == this.quote && !this.prevCharEscape) {
                            this.inQuote = false;
                            maybeInQuote = true;
                        }
                        this.prevCharEscape = ch == this.escape && !this.prevCharEscape && this.escape != this.quote;
                    }
                    this.prevCharCR = ch == '\r';
                    ++this.bufferPosn;
                }
                this.readLength = this.bufferPosn - startPosn;
                if (this.readLength <= 0) continue;
                this.record.append(this.inputBuffer, startPosn, this.readLength);
            } while (this.newlineLength == 0);
            if (this.record.isEmptyRecord()) continue;
            if (!this.newSource || !this.hasHeader) break;
            this.newSource = false;
        }
        return true;
    }
}

