/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.msgpack;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class MessagePackerFromADM {
    private static final int TYPE_TAG_SIZE = 1;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_SIZE = 4;
    private static final int ITEM_COUNT_SIZE = 4;
    private static final int ITEM_OFFSET_SIZE = 4;

    public static ATypeTag pack(IValueReference ptr, IAType type, ByteBuffer out, boolean packUnknown) throws HyracksDataException {
        return MessagePackerFromADM.pack(ptr.getByteArray(), ptr.getStartOffset(), type, true, packUnknown, out);
    }

    public static ATypeTag pack(byte[] ptr, int offs, IAType type, boolean tagged, boolean packUnknown, ByteBuffer out) throws HyracksDataException {
        int relOffs = tagged ? offs + 1 : offs;
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case STRING: {
                MessagePackerFromADM.packStr(ptr, relOffs, out);
                break;
            }
            case BOOLEAN: {
                if (BooleanPointable.getBoolean((byte[])ptr, (int)relOffs)) {
                    out.put((byte)-61);
                    break;
                }
                out.put((byte)-62);
                break;
            }
            case TINYINT: {
                MessagePackerFromADM.packByte(out, BytePointable.getByte((byte[])ptr, (int)relOffs));
                break;
            }
            case SMALLINT: {
                MessagePackerFromADM.packShort(out, ShortPointable.getShort((byte[])ptr, (int)relOffs));
                break;
            }
            case INTEGER: {
                MessagePackerFromADM.packInt(out, IntegerPointable.getInteger((byte[])ptr, (int)relOffs));
                break;
            }
            case BIGINT: {
                MessagePackerFromADM.packLong(out, LongPointable.getLong((byte[])ptr, (int)relOffs));
                break;
            }
            case FLOAT: {
                MessagePackerFromADM.packFloat(out, FloatPointable.getFloat((byte[])ptr, (int)relOffs));
                break;
            }
            case DOUBLE: {
                MessagePackerFromADM.packDouble(out, DoublePointable.getDouble((byte[])ptr, (int)relOffs));
                break;
            }
            case ARRAY: 
            case MULTISET: {
                MessagePackerFromADM.packArray(ptr, offs, type, out);
                break;
            }
            case OBJECT: {
                MessagePackerFromADM.packObject(ptr, offs, type, out);
                break;
            }
            case MISSING: 
            case NULL: {
                if (packUnknown) {
                    MessagePackerFromADM.packNull(out);
                    break;
                }
                return tag;
            }
            default: {
                throw HyracksDataException.create((Throwable)AsterixException.create((org.apache.asterix.common.exceptions.ErrorCode)org.apache.asterix.common.exceptions.ErrorCode.PARSER_ADM_DATA_PARSER_CAST_ERROR, (Serializable[])new Serializable[]{tag.name(), "to a msgpack"}));
            }
        }
        return ATypeTag.TYPE;
    }

    public static ATypeTag peekUnknown(IAType type) {
        switch (type.getTypeTag()) {
            case MISSING: 
            case NULL: {
                return type.getTypeTag();
            }
        }
        return ATypeTag.TYPE;
    }

    public static void packNull(ByteBuffer out) {
        out.put((byte)-64);
    }

    public static void packByte(ByteBuffer out, byte in) {
        out.put((byte)-48);
        out.put(in);
    }

    public static void packShort(ByteBuffer out, short in) {
        out.put((byte)-47);
        out.putShort(in);
    }

    public static void packInt(ByteBuffer out, int in) {
        out.put((byte)-46);
        out.putInt(in);
    }

    public static void packLong(ByteBuffer out, long in) {
        out.put((byte)-45);
        out.putLong(in);
    }

    public static void packFloat(ByteBuffer out, float in) {
        out.put((byte)-54);
        out.putFloat(in);
    }

    public static void packDouble(ByteBuffer out, double in) {
        out.put((byte)-53);
        out.putDouble(in);
    }

    public static void packFixPos(ByteBuffer out, byte in) throws HyracksDataException {
        int mask = -128;
        if ((in & mask) != 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"fixint7 must be positive"});
        }
        out.put(in);
    }

    public static void packFixStr(ByteBuffer buf, String in) throws HyracksDataException {
        byte[] strBytes = in.getBytes(StandardCharsets.UTF_8);
        if (strBytes.length > 31) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"fixint7 must be positive"});
        }
        buf.put((byte)(-96 + strBytes.length));
        buf.put(strBytes);
    }

    public static void packStr(ByteBuffer out, String in) {
        out.put((byte)-37);
        byte[] strBytes = in.getBytes(StandardCharsets.UTF_8);
        out.putInt(strBytes.length);
        out.put(strBytes);
    }

    private static void packStr(byte[] in, int offs, ByteBuffer out) {
        out.put((byte)-37);
        String str = UTF8StringUtil.toString((byte[])in, (int)offs);
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        out.putInt(strBytes.length);
        out.put(strBytes);
    }

    public static void packStr(String str, ByteBuffer out) {
        out.put((byte)-37);
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        out.putInt(strBytes.length);
        out.put(strBytes);
    }

    private static void packArray(byte[] in, int offs, IAType type, ByteBuffer out) throws HyracksDataException {
        AbstractCollectionType collType = (AbstractCollectionType)type;
        out.put((byte)-35);
        int lenOffs = offs + 1 + 1;
        int itemCtOffs = 4 + lenOffs;
        int itemCt = IntegerPointable.getInteger((byte[])in, (int)itemCtOffs);
        boolean fixType = NonTaggedFormatUtil.isFixedSizedCollection((IAType)type);
        out.putInt(itemCt);
        for (int i = 0; i < itemCt; ++i) {
            int itemOffs;
            if (fixType) {
                itemOffs = itemCtOffs + 4 + i * NonTaggedFormatUtil.getFieldValueLength((byte[])in, (int)0, (ATypeTag)collType.getItemType().getTypeTag(), (boolean)false);
                MessagePackerFromADM.pack(in, itemOffs, collType.getItemType(), false, true, out);
                continue;
            }
            itemOffs = offs + IntegerPointable.getInteger((byte[])in, (int)(itemCtOffs + 4 + i * 4));
            ATypeTag tag = ATypeTag.VALUE_TYPE_MAPPING[BytePointable.getByte((byte[])in, (int)itemOffs)];
            MessagePackerFromADM.pack(in, itemOffs, TypeTagUtil.getBuiltinTypeByTag((ATypeTag)tag), true, true, out);
        }
    }

    private static void packObject(byte[] in, int offs, IAType type, ByteBuffer out) throws HyracksDataException {
        int i;
        ARecordType recType = (ARecordType)type;
        out.put((byte)-33);
        int fieldCt = recType.getFieldNames().length + RecordUtils.getOpenFieldCount(in, offs, recType);
        out.putInt(fieldCt);
        for (i = 0; i < recType.getFieldNames().length; ++i) {
            String field = recType.getFieldNames()[i];
            IAType fieldType = RecordUtils.getClosedFieldType(recType, i);
            MessagePackerFromADM.packStr(field, out);
            MessagePackerFromADM.pack(in, RecordUtils.getClosedFieldOffset(in, offs, recType, i), fieldType, false, true, out);
        }
        if (RecordUtils.isExpanded(in, offs, recType)) {
            for (i = 0; i < RecordUtils.getOpenFieldCount(in, offs, recType); ++i) {
                MessagePackerFromADM.packStr(in, RecordUtils.getOpenFieldNameOffset(in, offs, recType, i), out);
                ATypeTag tag = ATypeTag.VALUE_TYPE_MAPPING[RecordUtils.getOpenFieldTag(in, offs, recType, i)];
                MessagePackerFromADM.pack(in, RecordUtils.getOpenFieldValueOffset(in, offs, recType, i), TypeTagUtil.getBuiltinTypeByTag((ATypeTag)tag), true, true, out);
            }
        }
    }

    public static void packFixArrayHeader(ByteBuffer buf, byte numObj) {
        buf.put((byte)(-112 + (0xF & numObj)));
    }

    private static class RecordUtils {
        static final int TAG_SIZE = 1;
        static final int RECORD_LENGTH_SIZE = 4;
        static final int EXPANDED_SIZE = 1;
        static final int OPEN_OFFSET_SIZE = 4;
        static final int CLOSED_COUNT_SIZE = 4;
        static final int FIELD_OFFSET_SIZE = 4;
        static final int OPEN_COUNT_SIZE = 4;
        private static final int OPEN_FIELD_HASH_SIZE = 4;
        private static final int OPEN_FIELD_OFFSET_SIZE = 4;
        private static final int OPEN_FIELD_HEADER = 8;

        private RecordUtils() {
        }

        private static boolean isOpen(ARecordType recordType) {
            return recordType == null || recordType.isOpen();
        }

        public static int getLength(byte[] bytes, int start) {
            return IntegerPointable.getInteger((byte[])bytes, (int)(start + 1));
        }

        public static boolean isExpanded(byte[] bytes, int start, ARecordType recordType) {
            return RecordUtils.isOpen(recordType) && BooleanPointable.getBoolean((byte[])bytes, (int)(start + 1 + 4));
        }

        public static int getOpenPartOffset(int start, ARecordType recordType) {
            return start + 1 + 4 + (RecordUtils.isOpen(recordType) ? 1 : 0);
        }

        public static int getNullBitmapOffset(byte[] bytes, int start, ARecordType recordType) {
            return RecordUtils.getOpenPartOffset(start, recordType) + (RecordUtils.isExpanded(bytes, start, recordType) ? 4 : 0) + 4;
        }

        public static int getNullBitmapSize(ARecordType recordType) {
            return RecordUtil.computeNullBitmapSize((ARecordType)recordType);
        }

        public static final IAType getClosedFieldType(ARecordType recordType, int fieldId) {
            IAType aType = recordType.getFieldTypes()[fieldId];
            if (NonTaggedFormatUtil.isOptional((IAType)aType)) {
                aType = ((AUnionType)aType).getActualType();
            }
            return aType;
        }

        public static final int getClosedFieldOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            int offset = RecordUtils.getNullBitmapOffset(bytes, start, recordType) + RecordUtils.getNullBitmapSize(recordType) + fieldId * 4;
            return start + IntegerPointable.getInteger((byte[])bytes, (int)offset);
        }

        public static final int getOpenFieldCount(byte[] bytes, int start, ARecordType recordType) {
            return RecordUtils.isExpanded(bytes, start, recordType) ? IntegerPointable.getInteger((byte[])bytes, (int)RecordUtils.getOpenFieldCountOffset(bytes, start, recordType)) : 0;
        }

        public static int getOpenFieldCountSize(byte[] bytes, int start, ARecordType recordType) {
            return RecordUtils.isExpanded(bytes, start, recordType) ? 4 : 0;
        }

        public static int getOpenFieldCountOffset(byte[] bytes, int start, ARecordType recordType) {
            return start + IntegerPointable.getInteger((byte[])bytes, (int)RecordUtils.getOpenPartOffset(start, recordType));
        }

        public static final int getOpenFieldValueOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return RecordUtils.getOpenFieldNameOffset(bytes, start, recordType, fieldId) + RecordUtils.getOpenFieldNameSize(bytes, start, recordType, fieldId);
        }

        public static int getOpenFieldNameSize(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            int utfleng = UTF8StringUtil.getUTFLength((byte[])bytes, (int)RecordUtils.getOpenFieldNameOffset(bytes, start, recordType, fieldId));
            return utfleng + UTF8StringUtil.getNumBytesToStoreLength((int)utfleng);
        }

        public static int getOpenFieldNameOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return RecordUtils.getOpenFieldOffset(bytes, start, recordType, fieldId);
        }

        public static final byte getOpenFieldTag(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return bytes[RecordUtils.getOpenFieldValueOffset(bytes, start, recordType, fieldId)];
        }

        public static int getOpenFieldHashOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return RecordUtils.getOpenFieldCountOffset(bytes, start, recordType) + RecordUtils.getOpenFieldCountSize(bytes, start, recordType) + fieldId * 8;
        }

        public static int getOpenFieldOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return start + IntegerPointable.getInteger((byte[])bytes, (int)RecordUtils.getOpenFieldOffsetOffset(bytes, start, recordType, fieldId));
        }

        public static int getOpenFieldOffsetOffset(byte[] bytes, int start, ARecordType recordType, int fieldId) {
            return RecordUtils.getOpenFieldHashOffset(bytes, start, recordType, fieldId) + 4;
        }
    }
}

