/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import reactor.core.publisher.AtomicSequence;
import reactor.core.publisher.MultiProducerRingBuffer;
import reactor.core.publisher.NotFunRingBuffer;
import reactor.core.publisher.RingBufferProducer;
import reactor.core.publisher.SingleProducerSequencer;
import reactor.core.publisher.UnsafeRingBuffer;
import reactor.core.publisher.UnsafeSequence;
import reactor.core.publisher.UnsafeSupport;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.concurrent.WaitStrategy;

abstract class RingBuffer<E>
implements LongSupplier {
    static final long INITIAL_CURSOR_VALUE = -1L;
    private static final boolean HAS_UNSAFE = RingBuffer.hasUnsafe0();

    RingBuffer() {
    }

    static <T> void addSequence(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> updater, Sequence sequence) {
        Sequence[] updatedSequences;
        Sequence[] currentSequences;
        do {
            currentSequences = updater.get(holder);
            updatedSequences = Arrays.copyOf(currentSequences, currentSequences.length + 1);
            updatedSequences[currentSequences.length] = sequence;
        } while (!updater.compareAndSet(holder, currentSequences, updatedSequences));
    }

    private static <T> int countMatching(T[] values, T toMatch) {
        int numToRemove = 0;
        for (T value : values) {
            if (value != toMatch) continue;
            ++numToRemove;
        }
        return numToRemove;
    }

    static <T> boolean removeSequence(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> sequenceUpdater, Sequence sequence) {
        Sequence[] oldSequences;
        int numToRemove;
        while (0 != (numToRemove = RingBuffer.countMatching(oldSequences = sequenceUpdater.get(holder), sequence))) {
            int oldSize = oldSequences.length;
            Sequence[] newSequences = new Sequence[oldSize - numToRemove];
            int pos = 0;
            for (int i = 0; i < oldSize; ++i) {
                Sequence testSequence = oldSequences[i];
                if (sequence == testSequence) continue;
                newSequences[pos++] = testSequence;
            }
            if (!sequenceUpdater.compareAndSet(holder, oldSequences, newSequences)) continue;
        }
        return numToRemove != 0;
    }

    static <E> RingBuffer<E> createMultiProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        if (RingBuffer.hasUnsafe()) {
            MultiProducerRingBuffer sequencer = new MultiProducerRingBuffer(bufferSize, waitStrategy, spinObserver);
            return new UnsafeRingBuffer<E>(factory, sequencer);
        }
        throw new IllegalStateException("This JVM does not support sun.misc.Unsafe");
    }

    static <E> RingBuffer<E> createSingleProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        return RingBuffer.createSingleProducer(factory, bufferSize, waitStrategy, null);
    }

    static <E> RingBuffer<E> createSingleProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy, @Nullable Runnable spinObserver) {
        SingleProducerSequencer sequencer = new SingleProducerSequencer(bufferSize, waitStrategy, spinObserver);
        if (RingBuffer.hasUnsafe() && Queues.isPowerOfTwo(bufferSize)) {
            return new UnsafeRingBuffer<E>(factory, sequencer);
        }
        return new NotFunRingBuffer<E>(factory, sequencer);
    }

    static long getMinimumSequence(Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].getAsLong();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    static long getMinimumSequence(@Nullable Sequence excludeSequence, Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            if (excludeSequence != null && sequences[i] == excludeSequence) continue;
            long value = sequences[i].getAsLong();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    static <T> T getUnsafe() {
        return (T)UnsafeSupport.getUnsafe();
    }

    static int log2(int i) {
        int r = 0;
        while ((i >>= 1) != 0) {
            ++r;
        }
        return r;
    }

    static Sequence newSequence(long init) {
        if (RingBuffer.hasUnsafe()) {
            return new UnsafeSequence(init);
        }
        return new AtomicSequence(init);
    }

    abstract void addGatingSequence(Sequence var1);

    abstract int bufferSize();

    abstract E get(long var1);

    @Override
    public long getAsLong() {
        return this.getCursor();
    }

    abstract long getCursor();

    abstract long getMinimumGatingSequence();

    abstract long getMinimumGatingSequence(Sequence var1);

    abstract int getPending();

    Sequence[] getSequenceReceivers() {
        return this.getSequencer().getGatingSequences();
    }

    abstract Reader newReader();

    abstract long next();

    abstract long next(int var1);

    abstract void publish(long var1);

    abstract boolean removeGatingSequence(Sequence var1);

    abstract RingBufferProducer getSequencer();

    static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    static boolean hasUnsafe0() {
        return UnsafeSupport.hasUnsafe();
    }

    static final class Reader {
        private final WaitStrategy waitStrategy;
        private volatile boolean alerted = false;
        private final Sequence cursorSequence;
        private final RingBufferProducer sequenceProducer;

        Reader(RingBufferProducer sequenceProducer, WaitStrategy waitStrategy, Sequence cursorSequence) {
            this.sequenceProducer = sequenceProducer;
            this.waitStrategy = waitStrategy;
            this.cursorSequence = cursorSequence;
        }

        long waitFor(long sequence, Runnable consumer) throws InterruptedException {
            long availableSequence;
            if (this.alerted) {
                WaitStrategy.alert();
            }
            if ((availableSequence = this.waitStrategy.waitFor(sequence, this.cursorSequence, consumer)) < sequence) {
                return availableSequence;
            }
            return this.sequenceProducer.getHighestPublishedSequence(sequence, availableSequence);
        }

        boolean isAlerted() {
            return this.alerted;
        }

        void alert() {
            this.alerted = true;
            this.waitStrategy.signalAllWhenBlocking();
        }

        void signal() {
            this.waitStrategy.signalAllWhenBlocking();
        }

        void clearAlert() {
            this.alerted = false;
        }
    }

    static interface Sequence
    extends LongSupplier {
        public static final long INITIAL_VALUE = -1L;

        public void set(long var1);

        public boolean compareAndSet(long var1, long var3);
    }
}

