/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.ipc.NodeControllerRemoteProxy;
import org.apache.logging.log4j.Level;

public class NodeHeartbeatWork
extends AbstractHeartbeatWork {
    private final InetSocketAddress ncAddress;

    public NodeHeartbeatWork(ClusterControllerService ccs, String nodeId, HeartbeatData hbData, InetSocketAddress ncAddress) {
        super(ccs, nodeId, hbData);
        this.ncAddress = ncAddress;
    }

    @Override
    public void runWork() throws Exception {
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState ncState = nodeManager.getNodeControllerState(this.nodeId);
        if (ncState != null) {
            ncState.getNodeController().heartbeatAck(this.ccs.getCcId(), null);
        } else {
            NodeControllerRemoteProxy nc = new NodeControllerRemoteProxy(this.ccs.getCcId(), this.ccs.getClusterIPC().getReconnectingHandle(this.ncAddress));
            nc.heartbeatAck(this.ccs.getCcId(), HyracksDataException.create((ErrorCode)ErrorCode.NO_SUCH_NODE, (Serializable[])new Serializable[]{this.nodeId}));
        }
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

