/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.netty.tcp.ProxyProvider;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientOperator;
import reactor.netty.tcp.TcpUtils;

final class TcpClientProxy
extends TcpClientOperator {
    final ProxyProvider proxyProvider;

    TcpClientProxy(TcpClient client, Consumer<? super ProxyProvider.TypeSpec> proxyOptions) {
        super(client);
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        ProxyProvider.Build builder = (ProxyProvider.Build)ProxyProvider.builder();
        proxyOptions.accept(builder);
        this.proxyProvider = builder.build();
    }

    @Override
    public Bootstrap configure() {
        return TcpUtils.updateProxySupport(this.source.configure(), this.proxyProvider);
    }

    @Override
    public ProxyProvider proxyProvider() {
        return this.proxyProvider;
    }
}

