/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io.profiling;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.control.nc.io.profiling.IIOCounter;
import org.apache.hyracks.util.Span;

abstract class IOCounterCache<T>
implements IIOCounter {
    private static final long TTL_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private Span span;
    private T info;

    IOCounterCache() {
    }

    protected synchronized T getInfo() throws IOException {
        if (this.info == null || this.span.elapsed()) {
            this.span = Span.start((long)TTL_NANOS, (TimeUnit)TimeUnit.NANOSECONDS);
            this.info = this.calculateInfo();
        }
        return this.info;
    }

    protected abstract T calculateInfo() throws IOException;
}

