/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize;

import java.io.Serializable;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.AbstractInvertedListSearchResultFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class FixedSizeInvertedListSearchResultFrameTupleAccessor
extends AbstractInvertedListSearchResultFrameTupleAccessor {
    private final int tupleSize;
    private final int[] fieldStartOffsets;

    public FixedSizeInvertedListSearchResultFrameTupleAccessor(int frameSize, ITypeTraits[] fields) throws HyracksDataException {
        super(frameSize, fields);
        this.fieldStartOffsets = new int[fields.length];
        this.fieldStartOffsets[0] = 0;
        for (int i = 1; i < fields.length; ++i) {
            this.fieldStartOffsets[i] = this.fieldStartOffsets[i - 1] + fields[i - 1].getFixedLength();
        }
        int tmp = 0;
        for (int i = 0; i < fields.length; ++i) {
            tmp += fields[i].getFixedLength();
        }
        this.tupleSize = tmp;
    }

    @Override
    protected void verifyTypeTraits() throws HyracksDataException {
        InvertedIndexUtils.verifyAllFixedSizeTypeTrait(this.fields);
        if (!InvertedIndexUtils.checkTypeTraitsAllFixed(this.fields)) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.INVALID_INVERTED_LIST_TYPE_TRAITS, (Serializable[])new Serializable[]{"expecting all type traits to be fixed-size while getting at least one variable-length one"});
        }
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.fieldStartOffsets[fIdx] + this.fields[fIdx].getFixedLength();
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.fields[fIdx].getFixedLength();
    }

    @Override
    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    @Override
    public int getFieldSlotsLength() {
        return 0;
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.fieldStartOffsets[fIdx];
    }

    @Override
    public int getTupleEndOffset(int tupleIndex) {
        return this.getFieldEndOffset(tupleIndex, this.fields.length - 1);
    }

    public int getTupleStartOffset(int tupleIndex) {
        return 4 + tupleIndex * this.tupleSize;
    }

    @Override
    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }
}

