/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;

public class EditDistanceSearchModifier
implements IInvertedIndexSearchModifier {
    protected int gramLength;
    protected int edThresh;

    public EditDistanceSearchModifier(int gramLength, int edThresh) {
        this.gramLength = gramLength;
        this.edThresh = edThresh;
    }

    @Override
    public int getOccurrenceThreshold(int numQueryTokens) {
        return numQueryTokens - this.edThresh * this.gramLength;
    }

    @Override
    public int getNumPrefixLists(int occurrenceThreshold, int numInvLists) {
        return numInvLists - occurrenceThreshold + 1;
    }

    @Override
    public short getNumTokensLowerBound(short numQueryTokens) {
        return (short)(numQueryTokens - this.edThresh);
    }

    @Override
    public short getNumTokensUpperBound(short numQueryTokens) {
        return (short)(numQueryTokens + this.edThresh);
    }

    public int getGramLength() {
        return this.gramLength;
    }

    public void setGramLength(int gramLength) {
        this.gramLength = gramLength;
    }

    public int getEdThresh() {
        return this.edThresh;
    }

    public void setEdThresh(int edThresh) {
        this.edThresh = edThresh;
    }

    public String toString() {
        return "Edit Distance Search Modifier, GramLen: " + this.gramLength + ", Threshold: " + this.edThresh;
    }
}

