/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.MultiComparator;

public class RTreeNSMLeafFrame
extends RTreeNSMFrame
implements IRTreeLeafFrame {
    public RTreeNSMLeafFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType, boolean isPointMBR) {
        super(tupleWriter, keyValueProviders, rtreePolicyType, isPointMBR);
    }

    public int getBytesRequiredToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + this.slotManager.getSlotSize();
    }

    public ITreeIndexTupleReference createTupleReference() {
        return this.tupleWriter.createTupleReference();
    }

    @Override
    public int findTupleIndex(ITupleReference tuple, MultiComparator cmp) throws HyracksDataException {
        return this.slotManager.findTupleIndex(tuple, this.frameTuple, cmp, null, null);
    }

    @Override
    public boolean intersect(ITupleReference tuple, int tupleIndex, MultiComparator cmp) throws HyracksDataException {
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j));
            if (c > 0) {
                return false;
            }
            c = cmp.getComparators()[i].compare(tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
            if (c >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTupleSize(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple);
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        this.slotManager.insertSlot(-1, this.buf.getInt(4));
        int bytesWritten = this.tupleWriter.writeTuple(tuple, this.buf.array(), this.buf.getInt(4));
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + bytesWritten);
        this.buf.putInt(17, this.buf.getInt(17) - bytesWritten - this.slotManager.getSlotSize());
    }

    @Override
    public void delete(int tupleIndex, MultiComparator cmp) {
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(0, this.buf.getInt(0) - 1);
        this.buf.putInt(17, this.buf.getInt(17) + tupleSize + this.slotManager.getSlotSize());
    }

    @Override
    public int getFieldCount() {
        return this.frameTuple.getFieldCount();
    }

    @Override
    public ITupleReference getBeforeTuple(ITupleReference tuple, int targetTupleIndex, MultiComparator cmp) throws HyracksDataException {
        if (targetTupleIndex != this.slotManager.getGreatestKeyIndicator()) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, targetTupleIndex);
            if (cmp.compare(tuple, (ITupleReference)this.frameTuple) == 0) {
                return this.frameTuple;
            }
        }
        return null;
    }
}

