/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds;

import com.teradata.tpcds.InvalidOptionException;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import io.airlift.airline.Option;
import java.util.Optional;

public class Options {
    public static final int DEFAULT_SCALE = 1;
    public static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_SUFFIX = ".dat";
    public static final String DEFAULT_TABLE = null;
    public static final String DEFAULT_NULL_STRING = "";
    public static final char DEFAULT_SEPARATOR = '|';
    public static final boolean DEFAULT_DO_NOT_TERMINATE = false;
    public static final boolean DEFAULT_NO_SEXISM = false;
    public static final int DEFAULT_PARALLELISM = 1;
    public static final boolean DEFAULT_OVERWRITE = false;
    @Option(name={"--scale", "-s"}, title="scale", description="Volume of data to generate in GB (Default: 1)")
    public double scale = 1.0;
    @Option(name={"--directory", "-d"}, title="directory", description="Directory to put generated files (Default: .) ")
    public String directory = ".";
    @Option(name={"--suffix"}, title="suffix", description="Suffix for generated data files (Default: .dat)")
    public String suffix = ".dat";
    @Option(name={"--table", "-t"}, title="table", description="Build only the specified table.  If this property is not specified, all tables will be generated")
    public String table = DEFAULT_TABLE;
    @Option(name={"--null"}, title="null", description="String representation for null values (Default: the empty string)")
    public String nullString = "";
    @Option(name={"--separator"}, title="separator", description="Separator between columns (Default: |)")
    public char separator = (char)124;
    @Option(name={"--do-not-terminate"}, title="do-not-terminate", description="Do not terminate each row with a separator (Default: false)")
    public boolean doNotTerminate = false;
    @Option(name={"--no-sexism"}, title="no-sexism", description="The reference C implementation picks only male names for the manager fields. This flag instructs our generator to pick managers from a distribution of male and female names. *The data set generated will differ from the one generated by the official C implementation.* But on the other hand it won't be sexist.")
    public boolean noSexism = false;
    @Option(name={"--parallelism"}, title="parallelism", description="Build data in <n> separate chunks (Default: 1)")
    public int parallelism = 1;
    @Option(name={"--overwrite"}, title="overwrite", description="Overwrite existing data files for tables")
    public boolean overwrite = false;

    public Session toSession() {
        this.validateProperties();
        return new Session(this.scale, this.directory, this.suffix, Options.toTableOptional(this.table), this.nullString, this.separator, this.doNotTerminate, this.noSexism, this.parallelism, this.overwrite);
    }

    private static Optional<Table> toTableOptional(String table) {
        if (table == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Table.valueOf(table.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOptionException("table", table);
        }
    }

    private void validateProperties() {
        if (this.scale < 0.0 || this.scale > 100000.0) {
            throw new InvalidOptionException("scale", Double.toString(this.scale), "Scale must be greater than 0 and less than 100000");
        }
        if (this.directory.equals(DEFAULT_NULL_STRING)) {
            throw new InvalidOptionException("directory", this.directory, "Directory cannot be an empty string");
        }
        if (this.suffix.equals(DEFAULT_NULL_STRING)) {
            throw new InvalidOptionException("suffix", this.suffix, "Suffix cannot be an empty string");
        }
        if (this.parallelism < 1) {
            throw new InvalidOptionException("parallelism", Integer.toString(this.parallelism), "Parallelism must be >= 1");
        }
    }
}

