/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.type;

import com.google.common.base.Preconditions;
import com.teradata.tpcds.PseudoTableScalingInfos;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.AddressDistributions;
import com.teradata.tpcds.distribution.FipsCountyDistribution;
import com.teradata.tpcds.random.RandomNumberStream;
import com.teradata.tpcds.random.RandomValueGenerator;
import java.util.Objects;

public class Address {
    private final String suiteNumber;
    private final int streetNumber;
    private final String streetName1;
    private final String streetName2;
    private final String streetType;
    private final String city;
    private final String county;
    private final String state;
    private final String country;
    private final int zip;
    private final int gmtOffset;

    public Address(String suiteNumber, int streetNumber, String streetName1, String streetName2, String streetType, String city, String county, String state, String country, int zip, int gmtOffset) {
        Objects.requireNonNull(suiteNumber, "suiteNumber is null");
        Preconditions.checkArgument((streetNumber >= 1 && streetNumber <= 1000 ? 1 : 0) != 0, (Object)"streetNumber is not between 1 and 1000");
        Objects.requireNonNull(streetName1, "streetName1 is null");
        Objects.requireNonNull(streetName2, "streetName2 is null");
        Objects.requireNonNull(streetType, "streetType is null");
        Objects.requireNonNull(city, "city is null");
        Objects.requireNonNull(country, "country is null");
        Preconditions.checkArgument((zip >= 0 && zip <= 99999 ? 1 : 0) != 0, (Object)"zip is not between 0 and 99999");
        this.suiteNumber = suiteNumber;
        this.streetNumber = streetNumber;
        this.streetName1 = streetName1;
        this.streetName2 = streetName2;
        this.streetType = streetType;
        this.city = city;
        this.county = county;
        this.state = state;
        this.country = country;
        this.zip = zip;
        this.gmtOffset = gmtOffset;
    }

    public static Address makeAddressForColumn(Table table, RandomNumberStream randomNumberStream, Scaling scaling) {
        int regionNumber;
        String city;
        AddressBuilder builder = new AddressBuilder();
        builder.setStreetNumber(RandomValueGenerator.generateUniformRandomInt(1, 1000, randomNumberStream));
        builder.setStreetName1(AddressDistributions.pickRandomStreetName(AddressDistributions.StreetNamesWeights.DEFAULT, randomNumberStream));
        builder.setStreetName2(AddressDistributions.pickRandomStreetName(AddressDistributions.StreetNamesWeights.HALF_EMPTY, randomNumberStream));
        builder.setStreetType(AddressDistributions.pickRandomStreetType(randomNumberStream));
        int randomInt = RandomValueGenerator.generateUniformRandomInt(1, 100, randomNumberStream);
        if (randomInt % 2 == 1) {
            builder.setSuiteNumber(String.format("Suite %d", randomInt / 2 * 10));
        } else {
            builder.setSuiteNumber(String.format("Suite %c", randomInt / 2 % 25 + 65));
        }
        int rowCount = (int)scaling.getRowCount(table);
        if (table.isSmall()) {
            int maxCities = (int)PseudoTableScalingInfos.ACTIVE_CITIES.getRowCountForScale(scaling.getScale());
            randomInt = RandomValueGenerator.generateUniformRandomInt(0, maxCities > rowCount ? rowCount - 1 : maxCities - 1, randomNumberStream);
            city = AddressDistributions.getCityAtIndex(randomInt);
        } else {
            city = AddressDistributions.pickRandomCity(AddressDistributions.CitiesWeights.UNIFIED_STEP_FUNCTION, randomNumberStream);
        }
        builder.setCity(city);
        if (table.isSmall()) {
            int maxCounties = (int)PseudoTableScalingInfos.ACTIVE_COUNTIES.getRowCountForScale(scaling.getScale());
            regionNumber = RandomValueGenerator.generateUniformRandomInt(0, maxCounties > rowCount ? rowCount - 1 : maxCounties - 1, randomNumberStream);
            builder.setCounty(FipsCountyDistribution.getCountyAtIndex(regionNumber));
        } else {
            regionNumber = FipsCountyDistribution.pickRandomIndex(FipsCountyDistribution.FipsWeights.UNIFORM, randomNumberStream);
            String county = FipsCountyDistribution.getCountyAtIndex(regionNumber);
            builder.setCounty(county);
        }
        builder.setState(FipsCountyDistribution.getStateAbbreviationAtIndex(regionNumber));
        int zip = Address.computeCityHash(city);
        int zipPrefix = FipsCountyDistribution.getZipPrefixAtIndex(regionNumber);
        if (zipPrefix == 0 && zip < 9400) {
            zip += 600;
        }
        builder.setZip(zip + zipPrefix * 10000);
        builder.setGmtOffset(FipsCountyDistribution.getGmtOffsetAtIndex(regionNumber));
        builder.setCountry("United States");
        return builder.build();
    }

    private static int computeCityHash(String name) {
        int hashValue = 0;
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            hashValue *= 26;
            if ((hashValue += name.charAt(i) - 65) <= 1000000) continue;
            result += (hashValue %= 10000);
            hashValue = 0;
        }
        result += (hashValue %= 1000);
        return result %= 10000;
    }

    public int getStreetNumber() {
        return this.streetNumber;
    }

    public String getStreetName() {
        return String.format("%s %s", this.streetName1, this.streetName2);
    }

    public String getSuiteNumber() {
        return this.suiteNumber;
    }

    public String getStreetType() {
        return this.streetType;
    }

    public String getCity() {
        return this.city;
    }

    public String getCounty() {
        return this.county;
    }

    public String getState() {
        return this.state;
    }

    public int getZip() {
        return this.zip;
    }

    public String getCountry() {
        return this.country;
    }

    public int getGmtOffset() {
        return this.gmtOffset;
    }

    public String getStreetName1() {
        return this.streetName1;
    }

    public String getStreetName2() {
        return this.streetName2;
    }

    public static class AddressBuilder {
        private String suiteNumber;
        private int streetNumber;
        private String streetName1;
        private String streetName2;
        private String streetType;
        private String city;
        private String county;
        private String state;
        private String country;
        private int zip;
        private int gmtOffset;

        public AddressBuilder setSuiteNumber(String suiteNumber) {
            this.suiteNumber = suiteNumber;
            return this;
        }

        public AddressBuilder setStreetNumber(int streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public AddressBuilder setStreetName1(String streetName1) {
            this.streetName1 = streetName1;
            return this;
        }

        public AddressBuilder setStreetName2(String streetName2) {
            this.streetName2 = streetName2;
            return this;
        }

        public AddressBuilder setStreetType(String streetType) {
            this.streetType = streetType;
            return this;
        }

        public AddressBuilder setCity(String city) {
            this.city = city;
            return this;
        }

        public AddressBuilder setCounty(String county) {
            this.county = county;
            return this;
        }

        public AddressBuilder setState(String state) {
            this.state = state;
            return this;
        }

        public AddressBuilder setCountry(String country) {
            this.country = country;
            return this;
        }

        public AddressBuilder setZip(int zip) {
            this.zip = zip;
            return this;
        }

        public AddressBuilder setGmtOffset(int gmtOffset) {
            this.gmtOffset = gmtOffset;
            return this;
        }

        public Address build() {
            return new Address(this.suiteNumber, this.streetNumber, this.streetName1, this.streetName2, this.streetType, this.city, this.county, this.state, this.country, this.zip, this.gmtOffset);
        }
    }
}

