/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpRequest;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;

class OperationDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Serializable pollStrategyData;
    private final Map<String, String> headers;
    private final String httpMethod;
    private final URL url;
    private final String fullyQualifiedMethodName;

    OperationDescription() {
        this.fullyQualifiedMethodName = null;
        this.pollStrategyData = null;
        this.headers = null;
        this.url = null;
        this.httpMethod = null;
    }

    OperationDescription(String fullyQualifiedMethodName, Serializable pollStrategyData, HttpRequest originalHttpRequest) {
        this.fullyQualifiedMethodName = fullyQualifiedMethodName;
        this.pollStrategyData = pollStrategyData;
        this.headers = originalHttpRequest.getHeaders().toMap();
        this.url = originalHttpRequest.getUrl();
        this.httpMethod = originalHttpRequest.getHttpMethod().toString();
    }

    public Serializable getPollStrategyData() {
        return this.pollStrategyData;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    String getMethodName() {
        int lastIndex = this.fullyQualifiedMethodName.lastIndexOf(".");
        return this.fullyQualifiedMethodName.substring(lastIndex + 1);
    }
}

