/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.List;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;

public class DefaultNodeGroupDomain
implements INodeDomain {
    private MultiSet<String> nodes = new HashMultiSet();

    public DefaultNodeGroupDomain(List<String> nodes) {
        this.nodes.addAll(nodes);
    }

    public DefaultNodeGroupDomain(DefaultNodeGroupDomain domain) {
        this.nodes.addAll(domain.nodes);
    }

    public DefaultNodeGroupDomain(AlgebricksPartitionConstraint clusterLocations) {
        if (clusterLocations.getPartitionConstraintType() == AlgebricksPartitionConstraint.PartitionConstraintType.ABSOLUTE) {
            String[] locations;
            AlgebricksAbsolutePartitionConstraint absPc = (AlgebricksAbsolutePartitionConstraint)clusterLocations;
            for (String location : locations = absPc.getLocations()) {
                this.nodes.add((Object)location);
            }
        } else {
            throw new IllegalStateException("A node domain can only take absolute location constraints.");
        }
    }

    @Override
    public boolean sameAs(INodeDomain domain) {
        if (!(domain instanceof DefaultNodeGroupDomain)) {
            return false;
        }
        DefaultNodeGroupDomain nodeDomain = (DefaultNodeGroupDomain)domain;
        return this.nodes.equals(nodeDomain.nodes);
    }

    public String toString() {
        return this.nodes.toString();
    }

    @Override
    public Integer cardinality() {
        return this.nodes.size();
    }

    public String[] getNodes() {
        return (String[])this.nodes.toArray((Object[])new String[0]);
    }
}

