/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.IoOperationCompleteListener;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public abstract class AbstractIoOperation
implements ILSMIOOperation {
    protected final ILSMIndexAccessor accessor;
    protected final FileReference target;
    protected final ILSMIOOperationCallback callback;
    protected final String indexIdentifier;
    private volatile Throwable failure;
    private ILSMIOOperation.LSMIOOperationStatus status = ILSMIOOperation.LSMIOOperationStatus.SUCCESS;
    private ILSMDiskComponent newComponent;
    private boolean completed = false;
    private List<IoOperationCompleteListener> completeListeners;
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    public AbstractIoOperation(ILSMIndexAccessor accessor, FileReference target, ILSMIOOperationCallback callback, String indexIdentifier) {
        this.accessor = accessor;
        this.target = target;
        this.callback = callback;
        this.indexIdentifier = indexIdentifier;
    }

    @Override
    public IODeviceHandle getDevice() {
        return this.target.getDeviceHandle();
    }

    @Override
    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    @Override
    public FileReference getTarget() {
        return this.target;
    }

    @Override
    public ILSMIndexAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public String getIndexIdentifier() {
        return this.indexIdentifier;
    }

    @Override
    public void cleanup(IBufferCache bufferCache) {
        FileReference[] files;
        LSMComponentFileReferences componentFiles = this.getComponentFiles();
        if (componentFiles == null) {
            return;
        }
        for (FileReference file : files = componentFiles.getFileReferences()) {
            try {
                if (file == null) continue;
                bufferCache.closeFileIfOpen(file);
                bufferCache.deleteFile(file);
            }
            catch (HyracksDataException hde) {
                this.getFailure().addSuppressed(hde);
            }
        }
    }

    protected abstract LSMComponentFileReferences getComponentFiles();

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public void setFailure(Throwable failure) {
        this.status = ILSMIOOperation.LSMIOOperationStatus.FAILURE;
        this.failure = ExceptionUtils.suppress((Throwable)this.failure, (Throwable)failure);
    }

    @Override
    public ILSMIOOperation.LSMIOOperationStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ILSMIOOperation.LSMIOOperationStatus status) {
        this.status = status;
    }

    @Override
    public ILSMDiskComponent getNewComponent() {
        return this.newComponent;
    }

    @Override
    public void setNewComponent(ILSMDiskComponent component) {
        this.newComponent = component;
    }

    @Override
    public synchronized void complete() {
        if (this.completed) {
            throw new IllegalStateException("Multiple destroy calls");
        }
        this.callback.completed(this);
        this.completed = true;
        if (this.completeListeners != null) {
            for (IoOperationCompleteListener listener : this.completeListeners) {
                listener.completed(this);
            }
            this.completeListeners = null;
        }
        this.notifyAll();
    }

    @Override
    public synchronized void sync() throws InterruptedException {
        while (!this.completed) {
            this.wait();
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.accessor.getOpContext().getParameters();
    }

    @Override
    public synchronized void addCompleteListener(IoOperationCompleteListener listener) {
        if (this.completed) {
            listener.completed(this);
        } else {
            if (this.completeListeners == null) {
                this.completeListeners = new LinkedList<IoOperationCompleteListener>();
            }
            this.completeListeners.add(listener);
        }
    }

    public void writeFailed(ICachedPage page, Throwable failure) {
        this.setFailure(failure);
    }

    public boolean hasFailed() {
        return this.status == ILSMIOOperation.LSMIOOperationStatus.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        AbstractIoOperation abstractIoOperation = this;
        synchronized (abstractIoOperation) {
            this.isActive.set(true);
            this.notifyAll();
        }
    }

    @Override
    public void pause() {
        this.isActive.set(false);
    }

    @Override
    public boolean isActive() {
        return this.isActive.get();
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitIfPaused() throws HyracksDataException {
        AbstractIoOperation abstractIoOperation = this;
        synchronized (abstractIoOperation) {
            while (!this.isActive.get()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)e);
                }
            }
        }
    }
}

