/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.storage.IReplicaManager;
import org.apache.asterix.common.storage.ReplicaIdentifier;
import org.apache.asterix.common.storage.ResourceStorageStats;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;

    public StorageApiServlet(ConcurrentMap<String, Object> ctx, INcApplicationContext appCtx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        PrintWriter responseWriter = response.writer();
        try {
            JsonNode json;
            response.setStatus(HttpResponseStatus.OK);
            String path = this.localPath(request);
            if ("".equals(path)) {
                json = this.getStatus(p -> true);
            } else if (path.startsWith("/partition")) {
                json = this.getPartitionStatus(path);
            } else if (path.startsWith("/stats")) {
                json = this.getStats();
            } else {
                throw new IllegalArgumentException();
            }
            JSONUtil.writeNode((Writer)responseWriter, (JsonNode)json);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, "Unrecognized path: " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }

    protected void post(IServletRequest request, IServletResponse response) throws Exception {
        switch (this.localPath(request)) {
            case "/addReplica": {
                this.processAddReplica(request, response);
                break;
            }
            case "/removeReplica": {
                this.processRemoveReplica(request, response);
                break;
            }
            case "/promote": {
                this.processPromote(request, response);
                break;
            }
            case "/release": {
                this.processRelease(request, response);
                break;
            }
            default: {
                this.sendError(response, HttpResponseStatus.NOT_FOUND);
            }
        }
    }

    private JsonNode getPartitionStatus(String path) {
        String[] token = path.split("/");
        if (token.length != 3) {
            throw new IllegalArgumentException();
        }
        Integer partition = Integer.valueOf(token[2]);
        return this.getStatus(partition::equals);
    }

    private JsonNode getStatus(Predicate<Integer> predicate) {
        ArrayNode status = OBJECT_MAPPER.createArrayNode();
        IReplicaManager storageSubsystem = this.appCtx.getReplicaManager();
        Set partitions = storageSubsystem.getPartitions().stream().filter(predicate).collect(Collectors.toSet());
        for (Integer partition : partitions) {
            ObjectNode partitionJson = OBJECT_MAPPER.createObjectNode();
            partitionJson.put("partition", partition);
            List replicas = storageSubsystem.getReplicas(partition.intValue());
            ArrayNode replicasArray = OBJECT_MAPPER.createArrayNode();
            for (IPartitionReplica replica : replicas) {
                ObjectNode replicaJson = OBJECT_MAPPER.createObjectNode();
                replicaJson.put("location", NetworkUtil.toHostPort((InetSocketAddress)replica.getIdentifier().getLocation()));
                replicaJson.put("status", replica.getStatus().toString());
                replicasArray.add((JsonNode)replicaJson);
            }
            partitionJson.set("replicas", (JsonNode)replicasArray);
            status.add((JsonNode)partitionJson);
        }
        return status;
    }

    private void processAddReplica(IServletRequest request, IServletResponse response) {
        ReplicaIdentifier replicaIdentifier = this.getReplicaIdentifier(request);
        if (replicaIdentifier == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.appCtx.getReplicaManager().addReplica(replicaIdentifier);
        response.setStatus(HttpResponseStatus.OK);
    }

    private void processRemoveReplica(IServletRequest request, IServletResponse response) {
        ReplicaIdentifier replicaIdentifier = this.getReplicaIdentifier(request);
        if (replicaIdentifier == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.appCtx.getReplicaManager().removeReplica(replicaIdentifier);
        response.setStatus(HttpResponseStatus.OK);
    }

    private ReplicaIdentifier getReplicaIdentifier(IServletRequest request) {
        String partition = request.getParameter((CharSequence)"partition");
        String host = request.getParameter((CharSequence)"host");
        String port = request.getParameter((CharSequence)"port");
        if (partition == null || host == null || port == null) {
            return null;
        }
        InetSocketAddress replicaAddress = new InetSocketAddress(host, (int)Integer.valueOf(port));
        return ReplicaIdentifier.of((int)Integer.valueOf(partition), (InetSocketAddress)replicaAddress);
    }

    private void processPromote(IServletRequest request, IServletResponse response) throws HyracksDataException {
        String partition = request.getParameter((CharSequence)"partition");
        if (partition == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.appCtx.getReplicaManager().promote(Integer.valueOf(partition).intValue());
        response.setStatus(HttpResponseStatus.OK);
    }

    private void processRelease(IServletRequest request, IServletResponse response) throws HyracksDataException {
        String partition = request.getParameter((CharSequence)"partition");
        if (partition == null) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            return;
        }
        this.appCtx.getReplicaManager().release(Integer.valueOf(partition).intValue());
        response.setStatus(HttpResponseStatus.OK);
    }

    private JsonNode getStats() throws HyracksDataException {
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        ArrayNode result = OBJECT_MAPPER.createArrayNode();
        List storageStats = localResourceRepository.getStorageStats();
        storageStats.stream().map(ResourceStorageStats::asJson).forEach(arg_0 -> ((ArrayNode)result).add(arg_0));
        return result;
    }
}

