/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import org.apache.hyracks.dataflow.std.structures.IResetable;

public final class TuplePointer
implements IResetable<TuplePointer> {
    public static final int INVALID_ID = -1;
    private int frameIndex;
    private int tupleIndex;

    public TuplePointer() {
        this(-1, -1);
    }

    public TuplePointer(int frameId, int tupleId) {
        this.reset(frameId, tupleId);
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    @Override
    public void reset(TuplePointer other) {
        this.reset(other.frameIndex, other.tupleIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TuplePointer that = (TuplePointer)o;
        return this.frameIndex == that.frameIndex && this.tupleIndex == that.tupleIndex;
    }

    public int hashCode() {
        int result = this.frameIndex;
        result = 31 * result + this.tupleIndex;
        return result;
    }

    public void reset(int frameId, int tupleId) {
        this.frameIndex = frameId;
        this.tupleIndex = tupleId;
    }

    public String toString() {
        return "TuplePointer(" + this.frameIndex + ", " + this.tupleIndex + ")";
    }
}

