/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;

public final class TranslationContext
implements IVariableContext {
    private Counter varCounter;
    private Deque<Map<Integer, LogicalVariable>> stack = new ArrayDeque<Map<Integer, LogicalVariable>>();
    private Map<Integer, LogicalVariable> currentVarMap = new HashMap<Integer, LogicalVariable>();
    private boolean topFlwor = true;

    public TranslationContext(Counter varCounter) {
        this.varCounter = varCounter;
    }

    public int getVarCounter() {
        return this.varCounter.get();
    }

    public LogicalVariable newVar() {
        return this.newVarFromExpression(null);
    }

    public LogicalVariable newVar(String displayName) {
        this.varCounter.inc();
        int varId = this.varCounter.get();
        LogicalVariable var = new LogicalVariable(varId, displayName);
        this.currentVarMap.put(varId, var);
        return var;
    }

    public void setVarCounter(int count) {
        this.varCounter.set(count);
    }

    public boolean isTopFlwor() {
        return this.topFlwor;
    }

    public void setTopFlwor(boolean b) {
        this.topFlwor = b;
    }

    public LogicalVariable getVar(Integer varId) {
        return this.currentVarMap.get(varId);
    }

    public LogicalVariable newVarFromExpression(Expression expr) {
        int varId;
        if (expr != null && expr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            VariableExpr v = (VariableExpr)expr;
            varId = v.getVar().getId();
            if (varId > this.varCounter.get()) {
                this.varCounter.set(varId);
            }
        } else {
            this.varCounter.inc();
            varId = this.varCounter.get();
        }
        LogicalVariable var = expr != null && (expr.getKind() == Expression.Kind.VARIABLE_EXPRESSION || expr.getKind() == Expression.Kind.FIELD_ACCESSOR_EXPRESSION) ? new LogicalVariable(varId, expr.toString()) : new LogicalVariable(varId);
        this.currentVarMap.put(varId, var);
        return var;
    }

    public void setVar(VariableExpr v, LogicalVariable var) {
        this.currentVarMap.put(v.getVar().getId(), var);
    }

    public void enterSubplan() {
        HashMap<Integer, LogicalVariable> varMap = new HashMap<Integer, LogicalVariable>();
        varMap.putAll(this.currentVarMap);
        this.stack.push(this.currentVarMap);
        this.currentVarMap = varMap;
    }

    public void exitSubplan() {
        if (!this.stack.isEmpty()) {
            this.currentVarMap = this.stack.pop();
        }
    }

    public LogicalVariable newSubplanOutputVar() {
        LogicalVariable newVar = this.newVar();
        if (!this.stack.isEmpty()) {
            Map<Integer, LogicalVariable> varMap = this.stack.peek();
            varMap.put(this.varCounter.get(), newVar);
        }
        return newVar;
    }
}

