/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.Set;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMBTreeWithBloomFilterDiskComponent
extends AbstractLSMWithBloomFilterDiskComponent {
    private final BTree btree;
    private final BloomFilter bloomFilter;

    public LSMBTreeWithBloomFilterDiskComponent(AbstractLSMIndex lsmIndex, BTree btree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super(lsmIndex, LSMBTreeDiskComponent.getMetadataPageManager(btree), filter);
        this.btree = btree;
        this.bloomFilter = bloomFilter;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public IBufferCache getBloomFilterBufferCache() {
        return this.getMetadataHolder().getBufferCache();
    }

    public long getComponentSize() {
        return LSMBTreeDiskComponent.getComponentSize(this.btree) + LSMBTreeWithBloomFilterDiskComponent.getComponentSize(this.bloomFilter);
    }

    public Set<String> getLSMComponentPhysicalFiles() {
        Set<String> files = LSMBTreeDiskComponent.getFiles(this.btree);
        LSMBTreeWithBloomFilterDiskComponent.addFiles(files, this.bloomFilter);
        return files;
    }

    static void addFiles(Set<String> files, BloomFilter bloomFilter) {
        files.add(bloomFilter.getFileReference().getFile().getAbsolutePath());
    }

    public int getFileReferenceCount() {
        return LSMBTreeDiskComponent.getFileReferenceCount(this.btree);
    }

    public BTree getMetadataHolder() {
        return this.btree;
    }

    public BTree getIndex() {
        return this.btree;
    }

    static long getComponentSize(BloomFilter bloomFilter) {
        return bloomFilter.getFileReference().getFile().length();
    }
}

