/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.collectors;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputChannelFrameReader
implements IFrameReader,
IInputChannelMonitor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IInputChannel channel;
    private int availableFrames;
    private boolean eos;
    private int errorCode;

    public InputChannelFrameReader(IInputChannel channel) {
        this.channel = channel;
        this.availableFrames = 0;
        this.errorCode = 0;
        this.eos = false;
    }

    public void open() throws HyracksDataException {
    }

    private boolean hasFailed() {
        return this.errorCode != 0;
    }

    private synchronized boolean canGetNextBuffer() throws HyracksDataException {
        while (!this.hasFailed() && !this.eos && this.availableFrames <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (this.hasFailed()) {
            if (this.errorCode == -1) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.LOCAL_NETWORK_ERROR, (Serializable[])new Serializable[0]);
            }
            LOGGER.warn("Sender failed.. returning silently");
            return false;
        }
        if (this.availableFrames <= 0 && this.eos) {
            return false;
        }
        --this.availableFrames;
        return true;
    }

    public boolean nextFrame(IFrame frame) throws HyracksDataException {
        if (!this.canGetNextBuffer()) {
            return false;
        }
        frame.reset();
        ByteBuffer srcFrame = this.channel.getNextBuffer();
        int nBlocks = FrameHelper.deserializeNumOfMinFrame((ByteBuffer)srcFrame);
        frame.ensureFrameSize(frame.getMinSize() * nBlocks);
        FrameUtils.copyWholeFrame((ByteBuffer)srcFrame, (ByteBuffer)frame.getBuffer());
        this.channel.recycleBuffer(srcFrame);
        for (int i = 1; i < nBlocks; ++i) {
            if (!this.canGetNextBuffer()) {
                return false;
            }
            srcFrame = this.channel.getNextBuffer();
            frame.getBuffer().put(srcFrame);
            this.channel.recycleBuffer(srcFrame);
        }
        if (frame.getBuffer().hasRemaining()) {
            FrameHelper.clearRemainingFrame((ByteBuffer)frame.getBuffer(), (int)frame.getBuffer().position());
        }
        frame.getBuffer().flip();
        return true;
    }

    public void close() throws HyracksDataException {
    }

    public synchronized void notifyFailure(IInputChannel channel, int errorCode) {
        this.errorCode = errorCode;
        this.notifyAll();
    }

    public synchronized void notifyDataAvailability(IInputChannel channel, int nFrames) {
        this.availableFrames += nFrames;
        this.notifyAll();
    }

    public synchronized void notifyEndOfStream(IInputChannel channel) {
        this.eos = true;
        this.notifyAll();
    }
}

