/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.cc.job.Task;
import org.apache.hyracks.control.cc.job.TaskClusterAttempt;
import org.apache.hyracks.control.cc.job.TaskClusterId;

public class TaskCluster {
    private final TaskClusterId taskClusterId;
    private final ActivityCluster ac;
    private final Task[] tasks;
    private final Set<PartitionId> producedPartitions;
    private final Set<PartitionId> requiredPartitions;
    private final Set<TaskCluster> dependencyTaskClusters;
    private final Set<TaskCluster> dependentTaskClusters;
    private final List<TaskClusterAttempt> taskClusterAttempts;

    public TaskCluster(TaskClusterId taskClusterId, ActivityCluster ac, Task[] tasks) {
        this.taskClusterId = taskClusterId;
        this.ac = ac;
        this.tasks = tasks;
        this.producedPartitions = new HashSet<PartitionId>();
        this.requiredPartitions = new HashSet<PartitionId>();
        this.dependencyTaskClusters = new HashSet<TaskCluster>();
        this.dependentTaskClusters = new HashSet<TaskCluster>();
        this.taskClusterAttempts = new ArrayList<TaskClusterAttempt>();
    }

    public TaskClusterId getTaskClusterId() {
        return this.taskClusterId;
    }

    public ActivityCluster getActivityCluster() {
        return this.ac;
    }

    public Task[] getTasks() {
        return this.tasks;
    }

    public Set<PartitionId> getProducedPartitions() {
        return this.producedPartitions;
    }

    public Set<PartitionId> getRequiredPartitions() {
        return this.requiredPartitions;
    }

    public Set<TaskCluster> getDependencyTaskClusters() {
        return this.dependencyTaskClusters;
    }

    public Set<TaskCluster> getDependentTaskClusters() {
        return this.dependentTaskClusters;
    }

    public List<TaskClusterAttempt> getAttempts() {
        return this.taskClusterAttempts;
    }

    public String toString() {
        return "TC:" + Arrays.toString(this.tasks);
    }
}

