/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.temporal.TimezoneHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

abstract class AbstractDatetimeFromUnixTimeEval
extends AbstractScalarEval {
    private final IScalarEvaluator arg0;
    private final IScalarEvaluator arg1;
    private final IPointable argPtr0;
    private final IPointable argPtr1;
    private final UTF8StringPointable utf8Ptr;
    protected final GregorianCalendarSystem cal = GregorianCalendarSystem.getInstance();
    protected final TimezoneHelper tzHelper;
    private final ISerializerDeserializer<ADateTime> datetimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
    private final AMutableDateTime aDatetime = new AMutableDateTime(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();

    AbstractDatetimeFromUnixTimeEval(IScalarEvaluator arg0, SourceLocation sourceLoc, FunctionIdentifier fid) {
        this(arg0, null, sourceLoc, fid);
    }

    AbstractDatetimeFromUnixTimeEval(IScalarEvaluator arg0, IScalarEvaluator arg1, SourceLocation sourceLoc, FunctionIdentifier fid) {
        super(sourceLoc, fid);
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.argPtr0 = new VoidPointable();
        this.argPtr1 = arg1 != null ? new VoidPointable() : null;
        this.utf8Ptr = arg1 != null ? new UTF8StringPointable() : null;
        this.tzHelper = new TimezoneHelper(sourceLoc, fid);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        long chrononAdjusted;
        long unixTime;
        this.arg0.evaluate(tuple, this.argPtr0);
        if (this.arg1 != null) {
            this.arg1.evaluate(tuple, this.argPtr1);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1)) {
            return;
        }
        byte[] bytes = this.argPtr0.getByteArray();
        int offset = this.argPtr0.getStartOffset();
        ATypeTag argPtrTypeTag = ATypeTag.VALUE_TYPE_MAPPING[bytes[offset]];
        switch (argPtrTypeTag) {
            case TINYINT: {
                unixTime = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                break;
            }
            case SMALLINT: {
                unixTime = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                break;
            }
            case INTEGER: {
                unixTime = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                break;
            }
            case BIGINT: {
                unixTime = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                break;
            }
            default: {
                throw new TypeMismatchException(this.srcLoc, this.funID, 0, bytes[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG);
            }
        }
        long chrononUTC = this.chrononFromUnixTime(unixTime);
        if (this.arg1 != null) {
            byte[] bytes1 = this.argPtr1.getByteArray();
            int offset1 = this.argPtr1.getStartOffset();
            int len1 = this.argPtr1.getLength();
            if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(this.srcLoc, this.funID, 1, bytes1[offset1], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            this.utf8Ptr.set(bytes1, offset1 + 1, len1 - 1);
            ZoneRules tzRules = this.tzHelper.parseTimeZone(this.utf8Ptr);
            ZoneOffset tzOffset = tzRules.getOffset(Instant.ofEpochMilli(chrononUTC));
            int tzOffsetMillis = (int)TimeUnit.SECONDS.toMillis(tzOffset.getTotalSeconds());
            chrononAdjusted = this.cal.adjustChrononByTimezone(chrononUTC, -tzOffsetMillis);
        } else {
            chrononAdjusted = chrononUTC;
        }
        this.resultStorage.reset();
        this.aDatetime.setValue(chrononAdjusted);
        this.datetimeSerde.serialize((Object)this.aDatetime, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract long chrononFromUnixTime(long var1);
}

