/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.io.IWritable;

public class TaskAttemptId
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private TaskId taskId;
    private int attempt;

    public static TaskAttemptId create(DataInput dis) throws IOException {
        TaskAttemptId taskAttemptId = new TaskAttemptId();
        taskAttemptId.readFields(dis);
        return taskAttemptId;
    }

    private TaskAttemptId() {
    }

    public TaskAttemptId(TaskId taskId, int attempt) {
        this.taskId = taskId;
        this.attempt = attempt;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TaskAttemptId)) {
            return false;
        }
        TaskAttemptId oTaskId = (TaskAttemptId)o;
        return oTaskId.attempt == this.attempt && oTaskId.taskId.equals(this.taskId);
    }

    public int hashCode() {
        return this.taskId.hashCode() + this.attempt;
    }

    public String toString() {
        return "TAID:" + this.taskId + ":" + this.attempt;
    }

    public static TaskAttemptId parse(String str) {
        if (str.startsWith("TAID:")) {
            str = str.substring(5);
            int idIdx = str.lastIndexOf(58);
            return new TaskAttemptId(TaskId.parse(str.substring(0, idIdx)), Integer.parseInt(str.substring(idIdx + 1)));
        }
        throw new IllegalArgumentException("Unable to parse: " + str);
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        this.taskId.writeFields(output);
        output.writeInt(this.attempt);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.taskId = TaskId.create(input);
        this.attempt = input.readInt();
    }
}

