/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.ComputingAction;
import org.apache.hyracks.util.IDelay;
import org.apache.hyracks.util.IOInterruptibleAction;
import org.apache.hyracks.util.IRetryPolicy;
import org.apache.hyracks.util.InterruptibleAction;
import org.apache.hyracks.util.Span;
import org.apache.hyracks.util.ThrowingAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvokeUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IFailedAttemptCallback defaultFailureCallback = (action, attempt, isFinal, span, failure) -> LOGGER.log(Level.WARN, "failure executing action {} (attempt: {}{})", (Object)action, (Object)attempt, (Object)(isFinal ? "" : ", will retry"), (Object)failure);

    private InvokeUtil() {
    }

    public static void doUninterruptibly(InterruptibleAction interruptible) {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    interruptible.run();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void doExUninterruptibly(ThrowingAction interruptible) throws Exception {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    interruptible.run();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean doUninterruptiblyGet(InterruptibleAction interruptible) {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                interruptible.run();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doExUninterruptiblyGet(Callable<Void> interruptible) throws Exception {
        boolean interrupted = Thread.interrupted();
        boolean success = false;
        while (true) {
            try {
                interruptible.call();
                success = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (success || !interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return interrupted;
    }

    public static boolean retryLoop(long duration, TimeUnit durationUnit, long delay, TimeUnit delayUnit, Callable<Boolean> function) throws IOException {
        long endTime = System.nanoTime() + durationUnit.toNanos(duration);
        boolean first = true;
        while (endTime - System.nanoTime() > 0L) {
            if (first) {
                first = false;
            } else {
                try {
                    delayUnit.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            try {
                if (!function.call().booleanValue()) continue;
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.DEBUG, "Ignoring exception on retryLoop attempt, will retry after delay", (Throwable)e);
            }
        }
        return false;
    }

    public static void doIoUninterruptibly(IOInterruptibleAction interruptible) throws IOException {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    interruptible.run();
                }
                catch (InterruptedException | ClosedByInterruptException e) {
                    LOGGER.error("IO operation Interrupted. Retrying..", (Throwable)e);
                    interrupted = true;
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryWithCleanups(ThrowingAction action, ThrowingAction ... cleanups) throws Exception {
        Throwable savedT = null;
        boolean suppressedInterrupted = false;
        try {
            action.run();
        }
        catch (Throwable t) {
            try {
                savedT = t;
            }
            catch (Throwable throwable) {
                for (ThrowingAction cleanup : cleanups) {
                    try {
                        cleanup.run();
                    }
                    catch (Throwable t2) {
                        if (savedT != null) {
                            savedT.addSuppressed(t2);
                            suppressedInterrupted = suppressedInterrupted || t2 instanceof InterruptedException;
                            continue;
                        }
                        savedT = t2;
                    }
                }
                throw throwable;
            }
            for (ThrowingAction cleanup : cleanups) {
                try {
                    cleanup.run();
                }
                catch (Throwable t3) {
                    if (savedT != null) {
                        savedT.addSuppressed(t3);
                        suppressedInterrupted = suppressedInterrupted || t3 instanceof InterruptedException;
                        continue;
                    }
                    savedT = t3;
                }
            }
        }
        for (ThrowingAction cleanup : cleanups) {
            try {
                cleanup.run();
            }
            catch (Throwable t) {
                if (savedT != null) {
                    savedT.addSuppressed(t);
                    suppressedInterrupted = suppressedInterrupted || t instanceof InterruptedException;
                    continue;
                }
                savedT = t;
            }
        }
        if (savedT == null) {
            return;
        }
        if (suppressedInterrupted) {
            Thread.currentThread().interrupt();
        }
        if (savedT instanceof Error) {
            throw (Error)savedT;
        }
        if (savedT instanceof Exception) {
            throw (Exception)savedT;
        }
        throw HyracksDataException.create(savedT);
    }

    public static void runUninterruptible(ThrowingAction action) throws Exception {
        boolean interrupted = Thread.interrupted();
        try {
            action.run();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("uninterruptible action {} was interrupted!", (Object)action, (Object)e);
            interrupted = true;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runWithTimeout(ThrowingAction action, BooleanSupplier stopCondition, long timeout, TimeUnit unit) throws Exception {
        long waitTime = unit.toNanos(timeout);
        long startTime = System.nanoTime();
        while (!stopCondition.getAsBoolean()) {
            action.run();
            if (System.nanoTime() - startTime < waitTime) continue;
            throw new TimeoutException("Stop condition was not met after " + unit.toSeconds(timeout) + " seconds.");
        }
    }

    public static <T> T retryUntilSuccessOrExhausted(Span span, ComputingAction<T> action, IRetryPolicy policy, IDelay delay) throws HyracksDataException {
        return InvokeUtil.retryUntilSuccessOrExhausted(span, action, policy, delay, defaultFailureCallback);
    }

    public static <T> T retryUntilSuccessOrExhausted(Span span, ComputingAction<T> action, IRetryPolicy policy, IDelay delay, IFailedAttemptCallback onFailure) throws HyracksDataException {
        int attempt = 0;
        while (!Thread.currentThread().isInterrupted()) {
            ++attempt;
            try {
                return (T)action.compute();
            }
            catch (Throwable th) {
                Throwable failure = th;
                try {
                    long delayMs = delay.calculate((long)attempt);
                    if (!policy.retry(th) || span.elapsed() || span.remaining(TimeUnit.MILLISECONDS) < delayMs) {
                        onFailure.attemptFailed(action, attempt, true, span, failure);
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw HyracksDataException.create(failure);
                    }
                    onFailure.attemptFailed(action, attempt, false, span, failure);
                    span.sleep(delayMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create(e);
                }
            }
        }
        throw HyracksDataException.create(new InterruptedException());
    }

    @FunctionalInterface
    public static interface IFailedAttemptCallback {
        public void attemptFailed(ComputingAction<?> var1, int var2, boolean var3, Span var4, Throwable var5);
    }
}

