/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;

public class AwsStatisticsCollector
extends RequestMetricCollector {
    private final StatisticsFromAwsSdk collector;

    public AwsStatisticsCollector(StatisticsFromAwsSdk collector) {
        this.collector = collector;
    }

    public void collectMetrics(Request<?> request, Response<?> response) {
        TimingInfo timingInfo = request.getAWSRequestMetrics().getTimingInfo();
        this.counter(timingInfo, AWSRequestMetrics.Field.HttpClientRetryCount.name(), this.collector::updateAwsRetryCount);
        this.counter(timingInfo, AWSRequestMetrics.Field.RequestCount.name(), this.collector::updateAwsRequestCount);
        this.counter(timingInfo, AWSRequestMetrics.Field.ThrottleException.name(), this.collector::updateAwsThrottleExceptionsCount);
        this.timing(timingInfo, AWSRequestMetrics.Field.ClientExecuteTime.name(), this.collector::noteAwsClientExecuteTime);
        this.timing(timingInfo, AWSRequestMetrics.Field.HttpRequestTime.name(), this.collector::noteAwsRequestTime);
        this.timing(timingInfo, AWSRequestMetrics.Field.RequestMarshallTime.name(), this.collector::noteRequestMarshallTime);
        this.timing(timingInfo, AWSRequestMetrics.Field.RequestSigningTime.name(), this.collector::noteRequestSigningTime);
        this.timing(timingInfo, AWSRequestMetrics.Field.ResponseProcessingTime.name(), this.collector::noteResponseProcessingTime);
    }

    private void timing(TimingInfo timingInfo, String subMeasurementName, Consumer<Duration> durationConsumer) {
        TimingInfo t1 = timingInfo.getSubMeasurement(subMeasurementName);
        if (t1 != null && t1.getTimeTakenMillisIfKnown() != null) {
            durationConsumer.accept(Duration.ofMillis(t1.getTimeTakenMillisIfKnown().longValue()));
        }
    }

    private void counter(TimingInfo timingInfo, String subMeasurementName, LongConsumer consumer) {
        Number n = timingInfo.getCounter(subMeasurementName);
        if (n != null) {
            consumer.accept(n.longValue());
        }
    }
}

