/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrationTasksRequestMessage
implements INCLifecycleMessage,
ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 2L;
    private final IRecoveryManager.SystemState state;
    private final String nodeId;
    private final NodeStatus nodeStatus;
    private final Map<String, Object> secrets;
    private final Set<Integer> activePartitions;

    public RegistrationTasksRequestMessage(String nodeId, NodeStatus nodeStatus, IRecoveryManager.SystemState state, Map<String, Object> secretsEphemeral, Set<Integer> activePartitions) {
        this.state = state;
        this.nodeId = nodeId;
        this.nodeStatus = nodeStatus;
        this.secrets = secretsEphemeral;
        this.activePartitions = activePartitions;
    }

    public static void send(CcId ccId, NodeControllerService cs, NodeStatus nodeStatus, IRecoveryManager.SystemState systemState, Map<String, Object> secretsEphemeral, Set<Integer> activePartitions) throws HyracksDataException {
        try {
            RegistrationTasksRequestMessage msg = new RegistrationTasksRequestMessage(cs.getId(), nodeStatus, systemState, secretsEphemeral, activePartitions);
            LOGGER.info("sending {} to CC", (Object)msg);
            ((INCMessageBroker)cs.getContext().getMessageBroker()).sendMessageToCC(ccId, (ICcAddressedMessage)msg);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unable to send RegistrationTasksRequestMessage to CC", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        appCtx.getNcLifecycleCoordinator().process((INCLifecycleMessage)this);
    }

    public IRecoveryManager.SystemState getState() {
        return this.state;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.REGISTRATION_TASKS_REQUEST;
    }

    public Map<String, Object> getSecrets() {
        return this.secrets;
    }

    public Set<Integer> getActivePartitions() {
        return this.activePartitions;
    }

    public String toString() {
        return "RegistrationTasksRequestMessage{state=" + this.state + ", nodeId='" + this.nodeId + "', nodeStatus=" + this.nodeStatus + ", activePartitions=" + this.activePartitions + "}";
    }
}

