/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.messaging.api.ICCMessageBroker;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.ICcIdentifiedMessage;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.messaging.api.INcResponse;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCMessageBroker
implements ICCMessageBroker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClusterControllerService ccs;
    private final Map<Long, MutablePair<MutableInt, MutablePair<ICCMessageBroker.ResponseState, Object>>> handles = new ConcurrentHashMap<Long, MutablePair<MutableInt, MutablePair<ICCMessageBroker.ResponseState, Object>>>();
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong(0L);
    private static final Object UNINITIALIZED = new Object();

    public CCMessageBroker(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    public void receivedMessage(IMessage message, String nodeId) throws Exception {
        ICcAddressedMessage msg = (ICcAddressedMessage)message;
        IMessage.logMessage((Logger)LOGGER, (IMessage)message);
        ICcApplicationContext appCtx = (ICcApplicationContext)this.ccs.getApplicationContext();
        msg.handle(appCtx);
    }

    public boolean sendApplicationMessageToNC(INcAddressedMessage msg, String nodeId) throws Exception {
        return this.sendMessage(msg, nodeId, false);
    }

    public boolean sendRealTimeApplicationMessageToNC(INcAddressedMessage msg, String nodeId) throws Exception {
        return this.sendMessage(msg, nodeId, true);
    }

    private boolean sendMessage(INcAddressedMessage msg, String nodeId, boolean realTime) throws Exception {
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState state = nodeManager.getNodeControllerState(nodeId);
        if (msg instanceof ICcIdentifiedMessage) {
            ((ICcIdentifiedMessage)msg).setCcId(this.ccs.getCcId());
        }
        if (state != null) {
            byte[] payload = JavaSerializationUtils.serialize((Serializable)msg);
            if (realTime) {
                state.getNodeController().sendRealTimeApplicationMessageToNC(payload, null, nodeId);
            } else {
                state.getNodeController().sendApplicationMessageToNC(payload, null, nodeId);
            }
            return true;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Couldn't send message to unregistered node (" + nodeId + ")");
        }
        return false;
    }

    public long newRequestId() {
        return REQUEST_ID_GENERATOR.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendSyncRequestToNCs(long reqId, List<String> ncs, List<? extends INcAddressedMessage> requests, long timeout, boolean realTime) throws Exception {
        MutableInt numRequired = new MutableInt(0);
        MutablePair pair = MutablePair.of((Object)numRequired, (Object)MutablePair.of((Object)ICCMessageBroker.ResponseState.UNINITIALIZED, (Object)UNINITIALIZED));
        ((MutableInt)pair.getKey()).setValue(ncs.size());
        this.handles.put(reqId, (MutablePair<MutableInt, MutablePair<ICCMessageBroker.ResponseState, Object>>)pair);
        try {
            MutablePair mutablePair = pair;
            synchronized (mutablePair) {
                for (int i = 0; i < ncs.size(); ++i) {
                    String nc = ncs.get(i);
                    INcAddressedMessage message = requests.get(i);
                    if (!(message instanceof ICcIdentifiedMessage)) {
                        throw new IllegalStateException("sync request message not cc identified: " + message);
                    }
                    if (!realTime ? this.sendApplicationMessageToNC(message, nc) : this.sendRealTimeApplicationMessageToNC(message, nc)) continue;
                    throw new RuntimeDataException(ErrorCode.ILLEGAL_STATE, new Serializable[]{"unable to send sync message to " + nc});
                }
                long time = System.currentTimeMillis();
                while (((MutableInt)pair.getLeft()).getValue() > 0) {
                    try {
                        pair.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw HyracksDataException.create((Throwable)e);
                    }
                    if (System.currentTimeMillis() - time <= timeout || ((MutableInt)pair.getLeft()).getValue() <= 0) continue;
                    throw new RuntimeDataException(ErrorCode.NC_REQUEST_TIMEOUT, new Serializable[]{Long.valueOf(timeout / 1000L)});
                }
            }
            MutablePair right = (MutablePair)pair.getRight();
            switch ((ICCMessageBroker.ResponseState)right.getKey()) {
                case FAILURE: {
                    throw HyracksDataException.create((Throwable)((Throwable)right.getValue()));
                }
                case SUCCESS: {
                    Object object = right.getRight();
                    return object;
                }
            }
            throw new RuntimeDataException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{String.valueOf(right.getKey())});
        }
        finally {
            this.handles.remove(reqId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void respond(Long reqId, INcResponse response) {
        Pair pair = (Pair)this.handles.get(reqId);
        if (pair == null) return;
        Pair pair2 = pair;
        // MONITORENTER : pair2
        try {
            MutablePair result = (MutablePair)pair.getValue();
            switch ((ICCMessageBroker.ResponseState)result.getKey()) {
                case SUCCESS: 
                case UNINITIALIZED: {
                    response.setResult(result);
                    return;
                }
            }
            return;
        }
        finally {
            MutableInt remainingResponses = (MutableInt)pair.getKey();
            remainingResponses.setValue(remainingResponses.getValue() - 1);
            pair.notifyAll();
        }
    }
}

