/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.io;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.util.IntSerDeUtils;

public class MessagingFrameTupleAppender
extends FrameTupleAppender {
    public static final int NULL_MESSAGE_SIZE = 1;
    public static final byte NULL_FEED_MESSAGE = 1;
    public static final byte ACK_REQ_FEED_MESSAGE = 2;
    public static final byte MARKER_MESSAGE = 3;
    private final IHyracksTaskContext ctx;
    private boolean initialized = false;
    private IFrame message;

    public MessagingFrameTupleAppender(IHyracksTaskContext ctx) {
        this.ctx = ctx;
    }

    public static void printMessage(IFrame message, PrintStream out) throws HyracksDataException {
        out.println(MessagingFrameTupleAppender.getMessageString(message));
    }

    public static String getMessageString(IFrame message) throws HyracksDataException {
        StringBuilder aString = new StringBuilder();
        aString.append("Message Type: ");
        switch (MessagingFrameTupleAppender.getMessageType(message)) {
            case 1: {
                aString.append("Null, ");
                break;
            }
            case 2: {
                aString.append("Ack Request, ");
                break;
            }
            case 3: {
                aString.append("Marker, ");
                break;
            }
            default: {
                aString.append("Unknown, ");
            }
        }
        aString.append("Message Length: ");
        int messageLength = message.getBuffer().remaining();
        aString.append(messageLength);
        return aString.toString();
    }

    public static byte getMessageType(IFrame message) throws HyracksDataException {
        switch (message.getBuffer().array()[0]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new HyracksDataException("Unknown message type");
    }

    @Override
    protected boolean canHoldNewTuple(int fieldCount, int dataLength) throws HyracksDataException {
        if (this.hasEnoughSpace(fieldCount + 1, dataLength + 1)) {
            return true;
        }
        if (this.tupleCount == 0) {
            this.frame.ensureFrameSize(FrameHelper.calcAlignedFrameSizeToStore((int)(fieldCount + 1), (int)(dataLength + 1), (int)this.frame.getMinSize()));
            this.reset(this.frame.getBuffer(), true);
            return true;
        }
        return false;
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount + 1;
    }

    @Override
    public void write(IFrameWriter outWriter, boolean clearFrame) throws HyracksDataException {
        this.failIfInterrupted();
        if (!this.initialized) {
            this.init();
        }
        if (this.message == null) {
            if (this.tupleCount > 0) {
                this.appendNullMessage();
                this.forward(outWriter);
            }
        } else {
            ByteBuffer buffer = this.message.getBuffer();
            int messageSize = buffer.limit() - buffer.position();
            if (this.hasEnoughSpace(0, messageSize)) {
                this.appendMessage(buffer);
                this.forward(outWriter);
            } else {
                if (this.tupleCount > 0) {
                    this.appendNullMessage();
                    this.forward(outWriter);
                }
                if (!this.hasEnoughSpace(0, messageSize)) {
                    this.frame.ensureFrameSize(FrameHelper.calcAlignedFrameSizeToStore((int)1, (int)messageSize, (int)this.frame.getMinSize()));
                    this.reset(this.frame.getBuffer(), true);
                }
                this.appendMessage(buffer);
                this.forward(outWriter);
            }
        }
    }

    private void init() {
        this.message = (IFrame)TaskUtil.get("HYX:MSG", this.ctx);
        this.initialized = true;
    }

    private void forward(IFrameWriter outWriter) throws HyracksDataException {
        this.getBuffer().clear();
        outWriter.nextFrame(this.getBuffer());
        this.frame.reset();
        this.reset(this.getBuffer(), true);
    }

    private void appendMessage(ByteBuffer message) {
        int messageLength = message.limit() - message.position();
        System.arraycopy(message.array(), message.position(), this.array, this.tupleDataEndOffset, messageLength);
        this.tupleDataEndOffset += messageLength;
        IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
        ++this.tupleCount;
        IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
    }

    private void appendNullMessage() {
        this.array[this.tupleDataEndOffset] = 1;
        ++this.tupleDataEndOffset;
        IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)(FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()) - 4 * (this.tupleCount + 1)), (int)this.tupleDataEndOffset);
        ++this.tupleCount;
        IntSerDeUtils.putInt((byte[])this.getBuffer().array(), (int)FrameHelper.getTupleCountOffset((int)this.frame.getFrameSize()), (int)this.tupleCount);
    }

    public void flush(IFrameWriter writer) throws HyracksDataException {
        this.write(writer, true);
        writer.flush();
    }
}

