/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.GrowableArray;

public class ArrayBackedValueStorage
implements IMutableValueStorage,
IPointable {
    private final GrowableArray data;

    public ArrayBackedValueStorage(int size) {
        this.data = new GrowableArray(size);
    }

    public ArrayBackedValueStorage() {
        this.data = new GrowableArray();
    }

    @Override
    public void reset() {
        this.data.reset();
    }

    @Override
    public DataOutput getDataOutput() {
        return this.data.getDataOutput();
    }

    @Override
    public byte[] getByteArray() {
        return this.data.getByteArray();
    }

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.data.getLength();
    }

    public void append(IValueReference value) throws HyracksDataException {
        try {
            this.data.append(value);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void assign(IValueReference value) throws HyracksDataException {
        this.reset();
        this.append(value);
    }

    public void setSize(int bytesRequired) {
        this.data.setSize(bytesRequired);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayBackedValueStorage)) {
            return false;
        }
        ArrayBackedValueStorage other = (ArrayBackedValueStorage)obj;
        return Objects.equals(this.data, other.data);
    }

    @Override
    public void set(byte[] bytes, int start, int length) {
        this.reset();
        if (bytes != null) {
            try {
                this.data.append(bytes, start, length);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void set(IValueReference pointer) {
        try {
            this.assign(pointer);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] toByteArray() {
        byte[] byteArray = new byte[this.getLength()];
        System.arraycopy(this.getByteArray(), this.getStartOffset(), byteArray, 0, this.getLength());
        return byteArray;
    }
}

