/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.algebra.operators.physical.IndexSearchPOperator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.BTreeJobGenParams;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;

public class BTreeSearchPOperator
extends IndexSearchPOperator {
    private final List<LogicalVariable> lowKeyVarList;
    private final List<LogicalVariable> highKeyVarList;
    private final boolean isPrimaryIndex;
    private final boolean isEqCondition;
    private Object implConfig;

    public BTreeSearchPOperator(IDataSourceIndex<String, DataSourceId> idx, INodeDomain domain, boolean requiresBroadcast, boolean isPrimaryIndex, boolean isEqCondition, List<LogicalVariable> lowKeyVarList, List<LogicalVariable> highKeyVarList) {
        super(idx, domain, requiresBroadcast);
        this.isPrimaryIndex = isPrimaryIndex;
        this.isEqCondition = isEqCondition;
        this.lowKeyVarList = lowKeyVarList;
        this.highKeyVarList = highKeyVarList;
    }

    public void setImplConfig(Object implConfig) {
        this.implConfig = implConfig;
    }

    public Object getImplConfig() {
        return this.implConfig;
    }

    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.BTREE_SEARCH;
    }

    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        AbstractUnnestMapOperator unnestMap = (AbstractUnnestMapOperator)op;
        ILogicalExpression unnestExpr = (ILogicalExpression)unnestMap.getExpressionRef().getValue();
        if (unnestExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            throw new IllegalStateException();
        }
        AbstractFunctionCallExpression unnestFuncExpr = (AbstractFunctionCallExpression)unnestExpr;
        FunctionIdentifier funcIdent = unnestFuncExpr.getFunctionIdentifier();
        if (!funcIdent.equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
            return;
        }
        BTreeJobGenParams jobGenParams = new BTreeJobGenParams();
        jobGenParams.readFromFuncArgs(unnestFuncExpr.getArguments());
        int[] lowKeyIndexes = this.getKeyIndexes(jobGenParams.getLowKeyVarList(), inputSchemas);
        int[] highKeyIndexes = this.getKeyIndexes(jobGenParams.getHighKeyVarList(), inputSchemas);
        boolean propagateFilter = unnestMap.propagateIndexFilter();
        IMissingWriterFactory nonFilterWriterFactory = BTreeSearchPOperator.getNonFilterWriterFactory(propagateFilter, context);
        int[] minFilterFieldIndexes = this.getKeyIndexes(unnestMap.getMinFilterVars(), inputSchemas);
        int[] maxFilterFieldIndexes = this.getKeyIndexes(unnestMap.getMaxFilterVars(), inputSchemas);
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = metadataProvider.findDataset(jobGenParams.getDataverseName(), jobGenParams.getDatasetName());
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        AsterixTupleFilterFactory tupleFilterFactory = null;
        long outputLimit = -1L;
        boolean retainMissing = false;
        IMissingWriterFactory nonMatchWriterFactory = null;
        switch (unnestMap.getOperatorTag()) {
            case UNNEST_MAP: {
                UnnestMapOperator unnestMapOp = (UnnestMapOperator)unnestMap;
                outputLimit = unnestMapOp.getOutputLimit();
                if (unnestMapOp.getSelectCondition() == null) break;
                tupleFilterFactory = metadataProvider.createTupleFilterFactory(new IOperatorSchema[]{opSchema}, typeEnv, (ILogicalExpression)unnestMapOp.getSelectCondition().getValue(), context);
                break;
            }
            case LEFT_OUTER_UNNEST_MAP: {
                retainMissing = true;
                nonMatchWriterFactory = BTreeSearchPOperator.getNonMatchWriterFactory(((LeftOuterUnnestMapOperator)unnestMap).getMissingValue(), context, unnestMap.getSourceLocation());
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestMap.getSourceLocation(), new Serializable[]{String.valueOf(unnestMap.getOperatorTag())});
            }
        }
        Pair btreeSearch = metadataProvider.buildBtreeRuntime(builder.getJobSpec(), opSchema, typeEnv, context, jobGenParams.getRetainInput(), retainMissing, nonMatchWriterFactory, dataset, jobGenParams.getIndexName(), lowKeyIndexes, highKeyIndexes, jobGenParams.isLowKeyInclusive(), jobGenParams.isHighKeyInclusive(), propagateFilter, nonFilterWriterFactory, minFilterFieldIndexes, maxFilterFieldIndexes, (ITupleFilterFactory)tupleFilterFactory, outputLimit, unnestMap.getGenerateCallBackProceedResultVar(), this.isPrimaryIndexPointSearch(op));
        IOperatorDescriptor opDesc = (IOperatorDescriptor)btreeSearch.first;
        opDesc.setSourceLocation(unnestMap.getSourceLocation());
        builder.contributeHyracksOperator((ILogicalOperator)unnestMap, opDesc);
        builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)btreeSearch.second);
        ILogicalOperator srcExchange = (ILogicalOperator)((Mutable)unnestMap.getInputs().get(0)).getValue();
        builder.contributeGraphEdge(srcExchange, 0, (ILogicalOperator)unnestMap, 0);
    }

    private boolean isPrimaryIndexPointSearch(ILogicalOperator op) {
        if (!(this.isEqCondition && this.isPrimaryIndex && this.lowKeyVarList.equals(this.highKeyVarList))) {
            return false;
        }
        Index searchIndex = ((DataSourceIndex)this.idx).getIndex();
        int numberOfKeyFields = ((Index.ValueIndexDetails)searchIndex.getIndexDetails()).getKeyFieldNames().size();
        if (this.lowKeyVarList.size() != numberOfKeyFields || this.highKeyVarList.size() != numberOfKeyFields) {
            return false;
        }
        IPhysicalPropertiesVector vector = ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getDeliveredPhysicalProperties();
        if (vector != null) {
            for (ILocalStructuralProperty property : vector.getLocalProperties()) {
                LocalOrderProperty orderProperty;
                if (property.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY || !(orderProperty = (LocalOrderProperty)property).getColumns().equals(this.lowKeyVarList) || !orderProperty.getOrders().stream().allMatch(o -> o.equals((Object)OrderOperator.IOrder.OrderKind.ASC))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        if (this.requiresBroadcast) {
            Index searchIndex;
            int numberOfKeyFields;
            if (this.isPrimaryIndex && this.isEqCondition && ((numberOfKeyFields = ((Index.ValueIndexDetails)(searchIndex = ((DataSourceIndex)this.idx).getIndex()).getIndexDetails()).getKeyFieldNames().size()) < 2 || this.lowKeyVarList.size() == numberOfKeyFields && this.highKeyVarList.size() == numberOfKeyFields)) {
                StructuralPropertiesVector[] pv = new StructuralPropertiesVector[1];
                ListSet searchKeyVars = new ListSet();
                searchKeyVars.addAll(this.lowKeyVarList);
                searchKeyVars.addAll(this.highKeyVarList);
                ArrayList<LocalOrderProperty> propsLocal = new ArrayList<LocalOrderProperty>();
                ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
                for (LogicalVariable orderVar : searchKeyVars) {
                    orderColumns.add(new OrderColumn(orderVar, OrderOperator.IOrder.OrderKind.ASC));
                }
                propsLocal.add(new LocalOrderProperty(orderColumns));
                pv[0] = new StructuralPropertiesVector((IPartitioningProperty)new UnorderedPartitionedProperty((Set)searchKeyVars, this.domain), propsLocal);
                return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
            }
            StructuralPropertiesVector[] pv = new StructuralPropertiesVector[]{new StructuralPropertiesVector((IPartitioningProperty)new BroadcastPartitioningProperty(this.domain), null)};
            return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return super.getRequiredPropertiesForChildren(op, reqdByParent, context);
    }
}

