/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class UniformInputTypeComputer
extends AbstractResultTypeComputer {
    public static final UniformInputTypeComputer STRING_STRING_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, BuiltinType.ASTRING);
    public static final UniformInputTypeComputer STRING_BOOLEAN_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, BuiltinType.ABOOLEAN);
    public static final UniformInputTypeComputer STRING_INT32_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, BuiltinType.AINT32);
    public static final UniformInputTypeComputer STRING_INT64_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, BuiltinType.AINT64);
    public static final UniformInputTypeComputer STRING_STRING_LIST_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, new AOrderedListType(BuiltinType.ASTRING, BuiltinType.ASTRING.getTypeName()));
    public static final UniformInputTypeComputer STRING_INT64_LIST_INSTANCE = new UniformInputTypeComputer(BuiltinType.ASTRING, new AOrderedListType(BuiltinType.AINT64, BuiltinType.AINT64.getTypeName()));
    private final IAType inputType;
    private final IAType outputType;

    private UniformInputTypeComputer(IAType inputType, IAType outputType) {
        this.inputType = inputType;
        this.outputType = outputType;
    }

    @Override
    public IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        for (IAType actualType : strippedInputTypes) {
            if (actualType.getTypeTag() == this.inputType.getTypeTag() || actualType.getTypeTag() == ATypeTag.ANY) continue;
            return BuiltinType.ANULL;
        }
        return this.outputType;
    }
}

