/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationName
implements ResourceName {
    private static final PathTemplate PROJECT_BUCKET_NOTIFICATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/buckets/{bucket}/notificationConfigs/{notification}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String bucket;
    private final String notification;

    @Deprecated
    protected NotificationName() {
        this.project = null;
        this.bucket = null;
        this.notification = null;
    }

    private NotificationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.bucket = (String)Preconditions.checkNotNull((Object)builder.getBucket());
        this.notification = (String)Preconditions.checkNotNull((Object)builder.getNotification());
    }

    public String getProject() {
        return this.project;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getNotification() {
        return this.notification;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationName of(String project, String bucket, String notification) {
        return NotificationName.newBuilder().setProject(project).setBucket(bucket).setNotification(notification).build();
    }

    public static String format(String project, String bucket, String notification) {
        return NotificationName.newBuilder().setProject(project).setBucket(bucket).setNotification(notification).build().toString();
    }

    public static NotificationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_BUCKET_NOTIFICATION.validatedMatch(formattedString, "NotificationName.parse: formattedString not in valid format");
        return NotificationName.of((String)matchMap.get("project"), (String)matchMap.get("bucket"), (String)matchMap.get("notification"));
    }

    public static List<NotificationName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationName> list = new ArrayList<NotificationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUCKET_NOTIFICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationName notificationName = this;
            synchronized (notificationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.bucket != null) {
                        fieldMapBuilder.put((Object)"bucket", (Object)this.bucket);
                    }
                    if (this.notification != null) {
                        fieldMapBuilder.put((Object)"notification", (Object)this.notification);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_BUCKET_NOTIFICATION.instantiate(new String[]{"project", this.project, "bucket", this.bucket, "notification", this.notification});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NotificationName that = (NotificationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.notification, that.notification);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.bucket);
        h *= 1000003;
        return h ^= Objects.hashCode(this.notification);
    }

    public static class Builder {
        private String project;
        private String bucket;
        private String notification;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String getNotification() {
            return this.notification;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setNotification(String notification) {
            this.notification = notification;
            return this;
        }

        private Builder(NotificationName notificationName) {
            this.project = notificationName.project;
            this.bucket = notificationName.bucket;
            this.notification = notificationName.notification;
        }

        public NotificationName build() {
            return new NotificationName(this);
        }
    }
}

