/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.properties;

import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.AbstractOrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PropertiesUtil;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class OrderedPartitionedProperty
extends AbstractOrderedPartitionedProperty {
    public OrderedPartitionedProperty(List<OrderColumn> orderColumns, INodeDomain domain) {
        super(orderColumns, domain);
    }

    public OrderedPartitionedProperty(List<OrderColumn> orderColumns, INodeDomain domain, RangeMap rangeMap) {
        super(orderColumns, domain, rangeMap);
    }

    @Override
    public IPartitioningProperty.PartitioningType getPartitioningType() {
        return IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED;
    }

    @Override
    public IPartitioningProperty normalize(Map<LogicalVariable, EquivalenceClass> equivalenceClasses, List<FunctionalDependency> fds) {
        List<OrderColumn> columns = PropertiesUtil.replaceOrderColumnsByEqClasses(this.orderColumns, equivalenceClasses);
        columns = PropertiesUtil.applyFDsToOrderColumns(columns, fds);
        return this.newInstance(columns, this.domain, this.rangeMap);
    }

    @Override
    protected AbstractOrderedPartitionedProperty newInstance(List<OrderColumn> orderColumns, INodeDomain domain, RangeMap rangeMap) {
        return new OrderedPartitionedProperty(orderColumns, domain, rangeMap);
    }
}

