/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.aggregators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;

public class FloatSumFieldAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final int aggField;
    private final boolean useObjectState;

    public FloatSumFieldAggregatorFactory(int aggField, boolean useObjState) {
        this.aggField = aggField;
        this.useObjectState = useObjState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                float sum = !FloatSumFieldAggregatorFactory.this.useObjectState ? FloatPointable.getFloat((byte[])data, (int)offset) : ((Float)state.state).floatValue();
                try {
                    fieldOutput.writeFloat(sum);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                float sum = !FloatSumFieldAggregatorFactory.this.useObjectState ? FloatPointable.getFloat((byte[])data, (int)offset) : ((Float)state.state).floatValue();
                try {
                    fieldOutput.writeFloat(sum);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public boolean needsObjectState() {
                return FloatSumFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public boolean needsBinaryState() {
                return !FloatSumFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                float sum = 0.0f;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, FloatSumFieldAggregatorFactory.this.aggField);
                sum += FloatPointable.getFloat((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                if (!FloatSumFieldAggregatorFactory.this.useObjectState) {
                    try {
                        fieldOutput.writeFloat(sum);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException("I/O exception when initializing the aggregator.");
                    }
                } else {
                    state.state = Float.valueOf(sum);
                }
            }

            @Override
            public AggregateState createState() {
                return new AggregateState(new Float(0.0));
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                float sum = 0.0f;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, FloatSumFieldAggregatorFactory.this.aggField);
                sum += FloatPointable.getFloat((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                if (!FloatSumFieldAggregatorFactory.this.useObjectState) {
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.putFloat(offset, sum += buf.getFloat(offset));
                } else {
                    state.state = Float.valueOf(sum += ((Float)state.state).floatValue());
                }
            }
        };
    }
}

