/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import org.apache.hyracks.dataflow.std.structures.AbstractHeap;
import org.apache.hyracks.dataflow.std.structures.IMaxHeap;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;

public class MaxHeap
extends AbstractHeap
implements IMaxHeap<IResetableComparable> {
    public MaxHeap(IResetableComparableFactory factory, int capacity) {
        super(factory, capacity);
    }

    @Override
    protected void bubbleUp(int i) {
        int pid = MaxHeap.getParentId(i);
        if (pid != -1 && this.compareTo(pid, i) < 0) {
            this.swap(pid, i);
            this.bubbleUp(pid);
        }
    }

    @Override
    protected void trickleDown(int i) {
        int maxChild = this.getMaxChild(i);
        if (maxChild != -1 && this.compareTo(i, maxChild) < 0) {
            this.swap(maxChild, i);
            this.trickleDown(maxChild);
        }
    }

    @Override
    public void getMax(IResetableComparable result) {
        result.reset(this.entries[0]);
        --this.numEntry;
        if (this.numEntry > 0) {
            this.entries[0].reset(this.entries[this.numEntry]);
            this.trickleDown(0);
        }
    }

    @Override
    public void peekMax(IResetableComparable result) {
        result.reset(this.entries[0]);
    }

    @Override
    public void replaceMax(IResetableComparable newElement) {
        this.entries[0].reset(newElement);
        this.trickleDown(0);
    }
}

