/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.ILogicalExpressionReferenceTransformWithCondition;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.api.exceptions.SourceLocation;

class MetaKeyToFieldAccessTransform
implements ILogicalExpressionReferenceTransformWithCondition {
    private final LogicalVariable metaVar;

    MetaKeyToFieldAccessTransform(LogicalVariable recordVar) {
        this.metaVar = recordVar;
    }

    public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
        FunctionIdentifier functionIdentifier;
        ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.META_KEY)) {
            return false;
        }
        SourceLocation sourceLoc = expr.getSourceLocation();
        List args = funcExpr.getArguments();
        ConstantExpression fieldNameExpression = (ConstantExpression)((Mutable)args.get(1)).getValue();
        AsterixConstantValue fieldNameValue = (AsterixConstantValue)fieldNameExpression.getValue();
        IAType fieldNameType = fieldNameValue.getObject().getType();
        switch (fieldNameType.getTypeTag()) {
            case ARRAY: {
                functionIdentifier = BuiltinFunctions.FIELD_ACCESS_NESTED;
                break;
            }
            case STRING: {
                functionIdentifier = BuiltinFunctions.FIELD_ACCESS_BY_NAME;
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Unsupported field name type " + fieldNameType.getTypeTag()});
            }
        }
        BuiltinFunctionInfo finfoAccess = FunctionUtil.getFunctionInfo((FunctionIdentifier)functionIdentifier);
        ArrayList<MutableObject> argExprs = new ArrayList<MutableObject>(2);
        VariableReferenceExpression metaVarRef = new VariableReferenceExpression(this.metaVar);
        metaVarRef.setSourceLocation(sourceLoc);
        argExprs.add(new MutableObject((Object)metaVarRef));
        argExprs.add(new MutableObject((Object)fieldNameExpression));
        ScalarFunctionCallExpression fAccessExpr = new ScalarFunctionCallExpression((IFunctionInfo)finfoAccess, argExprs);
        fAccessExpr.setSourceLocation(sourceLoc);
        exprRef.setValue((Object)fAccessExpr);
        return true;
    }
}

