/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.SessionConfig;
import org.apache.hyracks.util.JSONUtil;

public class ExecutionPlansJsonPrintUtil {
    private static final String LOGICAL_PLAN_LBL = "logicalPlan";
    private static final String EXPRESSION_TREE_LBL = "expressionTree";
    private static final String REWRITTEN_EXPRESSION_TREE_LBL = "rewrittenExpressionTree";
    public static final String OPTIMIZED_LOGICAL_PLAN_LBL = "optimizedLogicalPlan";
    private static final String JOB_LBL = "job";
    private static final String STATEMENT_CATEGORY_LBL = "statementCategory";
    private static final String STATEMENT_PARAMETERS_LBL = "statementParameters";
    private static final String EXPLAIN_ONLY_LBL = "explainOnly";

    private ExecutionPlansJsonPrintUtil() {
    }

    public static String asJson(ExecutionPlans plans, SessionConfig.PlanFormat format) {
        StringBuilder output = new StringBuilder();
        ExecutionPlansJsonPrintUtil.appendOutputPrefix(output);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, EXPRESSION_TREE_LBL, plans.getExpressionTree(), SessionConfig.PlanFormat.STRING);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, REWRITTEN_EXPRESSION_TREE_LBL, plans.getRewrittenExpressionTree(), SessionConfig.PlanFormat.STRING);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, LOGICAL_PLAN_LBL, plans.getLogicalPlan(), format);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, OPTIMIZED_LOGICAL_PLAN_LBL, plans.getOptimizedLogicalPlan(), format);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, JOB_LBL, plans.getJob(), format);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, STATEMENT_CATEGORY_LBL, plans.getStatementCategory(), SessionConfig.PlanFormat.STRING);
        ExecutionPlansJsonPrintUtil.appendNonNull(output, STATEMENT_PARAMETERS_LBL, plans.getStatementParameters(), SessionConfig.PlanFormat.JSON);
        if (plans.isExplainOnly()) {
            ExecutionPlansJsonPrintUtil.appendNonNull(output, EXPLAIN_ONLY_LBL, Boolean.toString(plans.isExplainOnly()), SessionConfig.PlanFormat.JSON);
        }
        ExecutionPlansJsonPrintUtil.appendOutputPostfix(output);
        return output.toString();
    }

    private static void appendNonNull(StringBuilder builder, String lbl, String value, SessionConfig.PlanFormat format) {
        if (value != null) {
            ExecutionPlansJsonPrintUtil.printFieldPrefix(builder, lbl);
            switch (format) {
                case JSON: {
                    builder.append(value);
                    break;
                }
                case STRING: {
                    JSONUtil.quoteAndEscape((StringBuilder)builder, (String)value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized plan format: " + format);
                }
            }
            ExecutionPlansJsonPrintUtil.printFieldPostfix(builder);
        }
    }

    private static void appendOutputPrefix(StringBuilder builder) {
        builder.append("{");
    }

    private static void printFieldPrefix(StringBuilder builder, String lbl) {
        builder.append("\"" + lbl + "\": ");
    }

    private static void printFieldPostfix(StringBuilder builder) {
        builder.append(",");
    }

    private static void appendOutputPostfix(StringBuilder builder) {
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("}");
    }
}

