/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AbstractVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.om.utils.ResettableByteArrayOutputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class ARecordVisitablePointable
extends AbstractVisitablePointable {
    static IObjectFactory<ARecordVisitablePointable, IAType> FACTORY = type -> new ARecordVisitablePointable((ARecordType)type);
    private final List<IVisitablePointable> fieldNames = new ArrayList<IVisitablePointable>();
    private final List<IVisitablePointable> fieldTypeTags = new ArrayList<IVisitablePointable>();
    private final List<IVisitablePointable> fieldValues = new ArrayList<IVisitablePointable>();
    private final PointableAllocator allocator = new PointableAllocator();
    private final ResettableByteArrayOutputStream typeBos = new ResettableByteArrayOutputStream();
    private final ResettableByteArrayOutputStream dataBos = new ResettableByteArrayOutputStream();
    private final DataOutputStream dataDos = new DataOutputStream((OutputStream)((Object)this.dataBos));
    private final ARecordType inputRecType;
    private final int numberOfSchemaFields;
    private final int[] fieldOffsets;
    private final IVisitablePointable nullReference = PointableAllocator.allocateUnrestableEmpty();
    private final IVisitablePointable missingReference = PointableAllocator.allocateUnrestableEmpty();
    private int closedPartTypeInfoSize = 0;
    private ATypeTag typeTag;

    public ARecordVisitablePointable(ARecordType inputType) {
        this.inputRecType = inputType;
        IAType[] fieldTypes = inputType.getFieldTypes();
        String[] fieldNameStrs = inputType.getFieldNames();
        this.numberOfSchemaFields = fieldTypes.length;
        try {
            DataOutputStream typeDos = new DataOutputStream((OutputStream)((Object)this.typeBos));
            UTF8StringWriter utf8Writer = new UTF8StringWriter();
            for (int i = 0; i < this.numberOfSchemaFields; ++i) {
                ATypeTag ftypeTag = fieldTypes[i].getTypeTag();
                if (NonTaggedFormatUtil.isOptional(fieldTypes[i])) {
                    ftypeTag = ((AUnionType)fieldTypes[i]).getActualType().getTypeTag();
                }
                int tagStart = this.typeBos.size();
                typeDos.writeByte(ftypeTag.serialize());
                int tagEnd = this.typeBos.size();
                IVisitablePointable typeTagReference = AFlatValuePointable.FACTORY.create(null);
                typeTagReference.set(this.typeBos.getByteArray(), tagStart, tagEnd - tagStart);
                this.fieldTypeTags.add(typeTagReference);
                int nameStart = this.typeBos.size();
                typeDos.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                utf8Writer.writeUTF8((CharSequence)fieldNameStrs[i], (DataOutput)typeDos);
                int nameEnd = this.typeBos.size();
                IVisitablePointable typeNameReference = AFlatValuePointable.FACTORY.create(null);
                typeNameReference.set(this.typeBos.getByteArray(), nameStart, nameEnd - nameStart);
                this.fieldNames.add(typeNameReference);
            }
            int nullFieldStart = this.typeBos.size();
            typeDos.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            int nullFieldEnd = this.typeBos.size();
            this.nullReference.set(this.typeBos.getByteArray(), nullFieldStart, nullFieldEnd - nullFieldStart);
            int missingFieldStart = this.typeBos.size();
            typeDos.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            int missingFieldEnd = this.typeBos.size();
            this.missingReference.set(this.typeBos.getByteArray(), missingFieldStart, missingFieldEnd - missingFieldStart);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.closedPartTypeInfoSize = this.typeBos.size();
        this.fieldOffsets = new int[this.numberOfSchemaFields];
    }

    private void reset() {
        int i;
        this.typeBos.reset(this.closedPartTypeInfoSize);
        this.dataBos.reset(0);
        this.allocator.reset();
        for (i = this.fieldNames.size() - 1; i >= this.numberOfSchemaFields; --i) {
            this.fieldNames.remove(i);
        }
        for (i = this.fieldTypeTags.size() - 1; i >= this.numberOfSchemaFields; --i) {
            this.fieldTypeTags.remove(i);
        }
        this.fieldValues.clear();
    }

    @Override
    public void set(byte[] b, int start, int len) {
        this.reset();
        super.set(b, start, len);
        boolean isExpanded = false;
        int openPartOffset = 0;
        int recordOffset = start;
        int s = start + 5;
        if (this.inputRecType.isOpen()) {
            isExpanded = b[s] == 1;
            ++s;
            if (isExpanded) {
                openPartOffset = start + AInt32SerializerDeserializer.getInt(b, s);
                s += 4;
            }
        }
        try {
            int i;
            if (this.numberOfSchemaFields > 0) {
                int offsetArrayOffset;
                s += 4;
                int nullBitMapOffset = 0;
                boolean hasOptionalFields = NonTaggedFormatUtil.hasOptionalField(this.inputRecType);
                if (hasOptionalFields) {
                    nullBitMapOffset = s;
                    offsetArrayOffset = s + (this.numberOfSchemaFields % 4 == 0 ? this.numberOfSchemaFields / 4 : this.numberOfSchemaFields / 4 + 1);
                } else {
                    offsetArrayOffset = s;
                }
                for (i = 0; i < this.numberOfSchemaFields; ++i) {
                    this.fieldOffsets[i] = AInt32SerializerDeserializer.getInt(b, offsetArrayOffset) + recordOffset;
                    offsetArrayOffset += 4;
                }
                for (int fieldNumber = 0; fieldNumber < this.numberOfSchemaFields; ++fieldNumber) {
                    if (hasOptionalFields) {
                        byte b1 = b[nullBitMapOffset + fieldNumber / 4];
                        if (RecordUtil.isNull(b1, fieldNumber)) {
                            this.fieldValues.add(this.nullReference);
                            continue;
                        }
                        if (RecordUtil.isMissing(b1, fieldNumber)) {
                            this.fieldValues.add(this.missingReference);
                            continue;
                        }
                    }
                    IAType[] fieldTypes = this.inputRecType.getFieldTypes();
                    int fieldValueLength = 0;
                    IAType fieldType = fieldTypes[fieldNumber];
                    if (fieldTypes[fieldNumber].getTypeTag() == ATypeTag.UNION) {
                        if (((AUnionType)fieldTypes[fieldNumber]).isUnknownableType()) {
                            fieldType = ((AUnionType)fieldTypes[fieldNumber]).getActualType();
                            this.typeTag = fieldType.getTypeTag();
                            fieldValueLength = NonTaggedFormatUtil.getFieldValueLength(b, this.fieldOffsets[fieldNumber], this.typeTag, false);
                        }
                    } else {
                        this.typeTag = fieldTypes[fieldNumber].getTypeTag();
                        fieldValueLength = NonTaggedFormatUtil.getFieldValueLength(b, this.fieldOffsets[fieldNumber], this.typeTag, false);
                    }
                    int fstart = this.dataBos.size();
                    this.dataDos.writeByte(this.typeTag.serialize());
                    this.dataDos.write(b, this.fieldOffsets[fieldNumber], fieldValueLength);
                    int fend = this.dataBos.size();
                    IVisitablePointable fieldValue = this.allocator.allocateFieldValue(fieldType);
                    fieldValue.set(this.dataBos.getByteArray(), fstart, fend - fstart);
                    this.fieldValues.add(fieldValue);
                }
            }
            if (isExpanded) {
                int numberOfOpenFields = AInt32SerializerDeserializer.getInt(b, openPartOffset);
                int fieldOffset = openPartOffset + 4 + 8 * numberOfOpenFields;
                for (i = 0; i < numberOfOpenFields; ++i) {
                    int fieldValueLength = NonTaggedFormatUtil.getFieldValueLength(b, fieldOffset, ATypeTag.STRING, false);
                    int fnstart = this.dataBos.size();
                    this.dataDos.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                    this.dataDos.write(b, fieldOffset, fieldValueLength);
                    int fnend = this.dataBos.size();
                    AFlatValuePointable fieldName = this.allocator.allocateEmpty();
                    fieldName.set(this.dataBos.getByteArray(), fnstart, fnend - fnstart);
                    this.fieldNames.add(fieldName);
                    AFlatValuePointable fieldTypeTag = this.allocator.allocateEmpty();
                    fieldTypeTag.set(b, fieldOffset += fieldValueLength, 1);
                    this.fieldTypeTags.add(fieldTypeTag);
                    this.typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b[fieldOffset]);
                    fieldValueLength = NonTaggedFormatUtil.getFieldValueLength(b, fieldOffset, this.typeTag, true) + 1;
                    IVisitablePointable fieldValueAccessor = this.allocator.allocateFieldValue(this.typeTag, b, fieldOffset + 1);
                    fieldValueAccessor.set(b, fieldOffset, fieldValueLength);
                    this.fieldValues.add(fieldValueAccessor);
                    fieldOffset += fieldValueLength;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<IVisitablePointable> getFieldNames() {
        return this.fieldNames;
    }

    public List<IVisitablePointable> getFieldTypeTags() {
        return this.fieldTypeTags;
    }

    public List<IVisitablePointable> getFieldValues() {
        return this.fieldValues;
    }

    public ARecordType getInputRecordType() {
        return this.inputRecType;
    }

    @Override
    public <R, T> R accept(IVisitablePointableVisitor<R, T> vistor, T tag) throws HyracksDataException {
        return vistor.visit(this, tag);
    }
}

