/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.asterix.transaction.management.service.transaction.AbstractTransactionContext;
import org.apache.asterix.transaction.management.service.transaction.TransactionContextFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionManager
implements ITransactionManager,
ILifeCycleComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITransactionSubsystem txnSubsystem;
    private final Map<TxnId, ITransactionContext> txnCtxRepository = new ConcurrentHashMap<TxnId, ITransactionContext>();
    private final AtomicLong maxTxnId = new AtomicLong(0L);

    public TransactionManager(ITransactionSubsystem provider) {
        this.txnSubsystem = provider;
    }

    public synchronized ITransactionContext beginTransaction(TxnId txnId, TransactionOptions options) throws ACIDException {
        ITransactionContext txnCtx = this.txnCtxRepository.get(txnId);
        if (txnCtx != null) {
            throw new ACIDException("Transaction with the same (" + txnId + ") already exists");
        }
        txnCtx = TransactionContextFactory.create(txnId, options);
        this.txnCtxRepository.put(txnId, txnCtx);
        this.ensureMaxTxnId(txnId.getId());
        return txnCtx;
    }

    public ITransactionContext getTransactionContext(TxnId txnId) throws ACIDException {
        ITransactionContext txnCtx = this.txnCtxRepository.get(txnId);
        if (txnCtx == null) {
            throw new ACIDException("Transaction " + txnId + " doesn't exist.");
        }
        return txnCtx;
    }

    public void commitTransaction(TxnId txnId) throws ACIDException {
        ITransactionContext txnCtx = this.getTransactionContext(txnId);
        try {
            if (txnCtx.isWriteTxn()) {
                LogRecord logRecord = new LogRecord();
                TransactionUtil.formJobTerminateLogRecord((ITransactionContext)txnCtx, (LogRecord)logRecord, (boolean)true);
                this.txnSubsystem.getLogManager().log((ILogRecord)logRecord);
                txnCtx.setTxnState(1);
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(" caused exception in commit !" + txnCtx.getTxnId());
            }
            throw e;
        }
        finally {
            txnCtx.complete();
            this.txnSubsystem.getLockManager().releaseLocks(txnCtx);
            this.txnCtxRepository.remove(txnCtx.getTxnId());
        }
    }

    public void abortTransaction(TxnId txnId) throws ACIDException {
        ITransactionContext txnCtx = this.getTransactionContext(txnId);
        try {
            if (txnCtx.isWriteTxn()) {
                if (txnCtx.getFirstLSN() != -1L) {
                    LogRecord logRecord = new LogRecord();
                    TransactionUtil.formJobTerminateLogRecord((ITransactionContext)txnCtx, (LogRecord)logRecord, (boolean)false);
                    this.txnSubsystem.getLogManager().log((ILogRecord)logRecord);
                    this.txnSubsystem.getCheckpointManager().secure(txnId);
                }
                this.txnSubsystem.getRecoveryManager().rollbackTransaction(txnCtx);
                txnCtx.setTxnState(2);
            }
        }
        catch (HyracksDataException e) {
            String msg = "Could not complete rollback! System is in an inconsistent state";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.log(Level.ERROR, msg, (Throwable)e);
            }
            throw new ACIDException(msg, (Throwable)e);
        }
        finally {
            txnCtx.complete();
            this.txnSubsystem.getLockManager().releaseLocks(txnCtx);
            this.txnCtxRepository.remove(txnCtx.getTxnId());
            this.txnSubsystem.getCheckpointManager().completed(txnId);
        }
    }

    public long getMaxTxnId() {
        return this.maxTxnId.get();
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) {
        if (dumpState) {
            this.dumpState(os);
        }
    }

    public void dumpState(OutputStream os) {
        this.dumpTxnContext(os);
    }

    public void ensureMaxTxnId(long txnId) {
        this.maxTxnId.updateAndGet(current -> Math.max(current, txnId));
    }

    private void dumpTxnContext(OutputStream os) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("\n>>dump_begin\t>>----- [ConfVars] -----");
            Set<Map.Entry<TxnId, ITransactionContext>> entrySet = this.txnCtxRepository.entrySet();
            for (Map.Entry<TxnId, ITransactionContext> entry : entrySet) {
                if (entry == null) continue;
                TxnId txnId = entry.getKey();
                if (txnId != null) {
                    sb.append("\n" + txnId);
                } else {
                    sb.append("\nJID:null");
                }
                ITransactionContext txnCtx = entry.getValue();
                if (txnCtx != null) {
                    sb.append(((AbstractTransactionContext)txnCtx).prettyPrint());
                    continue;
                }
                sb.append("\nTxnCtx:null");
            }
            sb.append("\n>>dump_end\t>>----- [ConfVars] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "exception while dumping state", (Throwable)e);
        }
    }
}

