/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.service.launcher.AbstractLaunchableService;
import org.apache.hadoop.service.launcher.ServiceLaunchException;

public class AbstractS3GuardDynamoDBDiagnostic
extends AbstractLaunchableService {
    private S3AFileSystem filesystem;
    private DynamoDBMetadataStore store;
    private URI uri;
    private List<String> arguments;

    public AbstractS3GuardDynamoDBDiagnostic(String name) {
        super(name);
    }

    public AbstractS3GuardDynamoDBDiagnostic(String name, @Nullable S3AFileSystem filesystem, @Nullable DynamoDBMetadataStore store, @Nullable URI uri) {
        super(name);
        this.store = store;
        this.filesystem = filesystem;
        if (store == null) {
            AbstractS3GuardDynamoDBDiagnostic.require(filesystem != null, "No filesystem or URI");
            this.bindStore(filesystem);
        }
        if (uri == null) {
            AbstractS3GuardDynamoDBDiagnostic.require(filesystem != null, "No filesystem or URI");
            this.setUri(filesystem.getUri());
        } else {
            this.setUri(uri);
        }
    }

    protected static void require(boolean condition, String error) {
        if (!condition) {
            throw AbstractS3GuardDynamoDBDiagnostic.failure(error);
        }
    }

    protected static ServiceLaunchException failure(String message, Throwable ex) {
        return new ServiceLaunchException(-1, message, new Object[]{ex});
    }

    protected static ServiceLaunchException failure(String message) {
        return new ServiceLaunchException(-1, message);
    }

    public Configuration bindArgs(Configuration config, List<String> args) throws Exception {
        this.arguments = args;
        return super.bindArgs(config, args);
    }

    protected List<String> getArguments() {
        return this.arguments;
    }

    protected void bindFromCLI(String fsURI) throws IOException {
        Configuration conf = this.getConfig();
        this.setUri(fsURI);
        FileSystem fs = FileSystem.get((URI)this.getUri(), (Configuration)conf);
        AbstractS3GuardDynamoDBDiagnostic.require(fs instanceof S3AFileSystem, "Not an S3A Filesystem:  " + fsURI);
        this.filesystem = (S3AFileSystem)fs;
        this.bindStore(this.filesystem);
        this.setUri(fs.getUri());
    }

    private void bindStore(S3AFileSystem fs) {
        AbstractS3GuardDynamoDBDiagnostic.require(fs.hasMetadataStore(), "Filesystem has no metadata store: " + fs.getUri());
        MetadataStore ms = fs.getMetadataStore();
        AbstractS3GuardDynamoDBDiagnostic.require(ms instanceof DynamoDBMetadataStore, "Filesystem " + fs.getUri() + " does not have a DynamoDB metadata store:  " + ms);
        this.store = (DynamoDBMetadataStore)ms;
    }

    protected DynamoDBMetadataStore getStore() {
        return this.store;
    }

    public S3AFileSystem getFilesystem() {
        return this.filesystem;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        String fsURI = uri.toString();
        if (!fsURI.endsWith("/")) {
            this.setUri(fsURI);
        } else {
            this.uri = uri;
        }
    }

    public void setUri(String fsURI) {
        if (fsURI != null) {
            if (!fsURI.endsWith("/")) {
                fsURI = fsURI + "/";
            }
            try {
                this.setUri(new URI(fsURI));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected List<String> getArgumentList(int argMin, int argMax, String usage) {
        List<String> arg = this.getArguments();
        if (arg == null || arg.size() < argMin || arg.size() > argMax) {
            throw new ServiceLaunchException(42, usage);
        }
        return arg;
    }
}

