/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PromiseNotificationUtil;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestCapacityController
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpServer server;
    private boolean overloaded = false;

    public HttpRequestCapacityController(HttpServer server) {
        this.server = server;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.overloaded) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (this.overloaded()) {
            ReferenceCountUtil.release((Object)msg);
            HttpRequestCapacityController.reject(ctx);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public static void reject(ChannelHandlerContext ctx) {
        HttpResponseEncoder encoder = new HttpResponseEncoder();
        ChannelPromise promise = ctx.newPromise();
        promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE);
        try {
            encoder.write(ctx, (Object)response, ctx.voidPromise());
            ctx.writeAndFlush((Object)ctx.alloc().buffer(0), promise);
        }
        catch (Throwable th) {
            try {
                LOGGER.log(Level.ERROR, "Failure during request rejection", th);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            PromiseNotificationUtil.tryFailure((Promise)promise, (Throwable)th, null);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.overloaded()) {
            HttpRequestCapacityController.reject(ctx);
            return;
        }
        ctx.read();
        super.channelActive(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        super.channelReadComplete(ctx);
    }

    private boolean overloaded() {
        if (!this.overloaded) {
            this.overloaded = this.server.getExecutor(null).getQueue().remainingCapacity() == 0;
        }
        return this.overloaded;
    }
}

