/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.drivers;

import java.io.FileReader;
import java.io.OutputStream;
import org.apache.asterix.api.common.AsterixClientConfig;
import org.apache.asterix.api.java.AsterixJavaClient;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.SqlppCompilationProvider;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.ipc.impl.HyracksConnection;
import org.kohsuke.args4j.CmdLineParser;

public class AsterixClientDriver {
    public static void main(String[] args) throws Exception {
        AsterixClientConfig acc = new AsterixClientConfig();
        CmdLineParser cmdParser = new CmdLineParser((Object)acc);
        try {
            cmdParser.parseArgument(args);
        }
        catch (Exception e) {
            cmdParser.printUsage((OutputStream)System.err);
            throw e;
        }
        if (acc.getArguments().isEmpty()) {
            System.err.println("Please specify the file containing the query.");
            return;
        }
        if (acc.getArguments().size() > 1) {
            System.err.print("Too many arguments. ");
            System.err.println("Only the file contained the query needs to be specified.");
            return;
        }
        boolean exec = new Boolean(acc.execute);
        HyracksConnection hcc = exec ? new HyracksConnection("localhost", acc.hyracksPort) : null;
        AsterixJavaClient q = AsterixClientDriver.compileQuery((IHyracksClientConnection)hcc, acc.getArguments().get(0), new Boolean(acc.optimize), false, exec || new Boolean(acc.hyracksJob) != false);
        if (exec) {
            q.execute();
        }
    }

    private static AsterixJavaClient compileQuery(IHyracksClientConnection hcc, String filename, boolean optimize, boolean onlyPhysical, boolean createBinaryRuntime) throws Exception {
        SqlppCompilationProvider compilationProvider = new SqlppCompilationProvider();
        FileReader reader = new FileReader(filename);
        AsterixJavaClient q = new AsterixJavaClient(null, hcc, reader, (ILangCompilationProvider)compilationProvider, new DefaultStatementExecutorFactory(), new StorageComponentProvider());
        q.compile(optimize, true, true, true, onlyPhysical, createBinaryRuntime, createBinaryRuntime);
        return q;
    }
}

