/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.utils;

import java.io.Serializable;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.app.cc.IStatementExecutorExtension;
import org.apache.asterix.common.api.ExtensionId;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ExtensionUtil {
    private ExtensionUtil() {
    }

    public static Pair<ExtensionId, ILangCompilationProvider> extendLangCompilationProvider(ILangExtension.Language lang, Pair<ExtensionId, ILangCompilationProvider> cp, ILangExtension le) throws RuntimeDataException {
        ILangCompilationProvider lecp = le.getLangCompilationProvider(lang);
        if (cp != null && lecp != null) {
            throw new RuntimeDataException(ErrorCode.EXTENSION_COMPONENT_CONFLICT, new Serializable[]{le.getId(), (Serializable)cp.first, lang.toString()});
        }
        return lecp != null ? new Pair((Object)le.getId(), (Object)lecp) : cp;
    }

    public static Pair<ExtensionId, IFunctionManager> extendFunctionManager(Pair<ExtensionId, IFunctionManager> fm, ILangExtension le) throws RuntimeDataException {
        IFunctionManager lefm = le.getFunctionManager();
        if (fm != null && lefm != null) {
            throw new RuntimeDataException(ErrorCode.EXTENSION_COMPONENT_CONFLICT, new Serializable[]{le.getId(), (Serializable)fm.first, IFunctionManager.class.getSimpleName()});
        }
        return lefm != null ? new Pair((Object)le.getId(), (Object)lefm) : fm;
    }

    public static IStatementExecutorExtension extendStatementExecutor(IStatementExecutorExtension see, IStatementExecutorExtension extension) throws RuntimeDataException {
        if (see != null) {
            throw new RuntimeDataException(ErrorCode.EXTENSION_COMPONENT_CONFLICT, new Serializable[]{see.getId(), extension.getId(), IStatementExecutorFactory.class.getSimpleName()});
        }
        return extension;
    }

    public static IMetadataExtension extendTupleTranslatorProvider(IMetadataExtension metadataExtension, IMetadataExtension mde) throws RuntimeDataException {
        if (metadataExtension != null) {
            throw new RuntimeDataException(ErrorCode.EXTENSION_COMPONENT_CONFLICT, new Serializable[]{metadataExtension.getId(), mde.getId(), IMetadataExtension.class.getSimpleName()});
        }
        return mde.getMetadataTupleTranslatorProvider() == null ? null : mde;
    }

    public static IMetadataExtension extendMetadataProviderFactory(IMetadataExtension metadataExtension, IMetadataExtension mde) throws RuntimeDataException {
        if (metadataExtension != null) {
            throw new RuntimeDataException(ErrorCode.EXTENSION_COMPONENT_CONFLICT, new Serializable[]{metadataExtension.getId(), mde.getId(), IMetadataExtension.class.getSimpleName()});
        }
        return mde.getMetadataProviderFactory() == null ? null : mde;
    }
}

